import QtQuick 1.1


Rectangle {
    id: textshow
    width: 500
    height: 500
    color:"lightgray"
    property string label: "label"
    property alias content: edit.text
    property bool readonly: false


    Text {
        id: label
        width:textshow.width
        height:20
        text: textshow.label
        font.pixelSize: 15
    }

    Rectangle {
        id: textrec
        width: textshow.width
        height: textshow.height-20
        anchors.bottom:  textshow.bottom


        border.color: "black"
        border.width: 0


        Flickable {
             id: flick

             anchors.fill:parent
             contentWidth: edit.paintedWidth
             contentHeight: edit.paintedHeight
             flickableDirection: Flickable.VerticalFlick
             clip: true

             function ensureVisible(r)
             {
                 if (contentX >= r.x)
                     contentX = r.x;
                 else if (contentX+width <= r.x+r.width)
                     contentX = r.x+r.width-width;
                 if (contentY >= r.y)
                     contentY = r.y;
                 else if (contentY+height <= r.y+r.height)
                     contentY = r.y+r.height-height;
             }

             TextEdit {
                 id: edit
                 width: flick.width
                 height: flick.height
                 focus: true

                 text: ""

                 textFormat: TextEdit.PlainText
                 selectByMouse: true;
                 readOnly:textshow.readonly
                 font.pixelSize: 15

                 onCursorRectangleChanged: flick.ensureVisible(cursorRectangle)
             }
         }



        /*Flickable {
            id: flickArea
            anchors.fill: parent
            contentWidth: textContent.width; contentHeight: textContent.height
            flickableDirection: Flickable.VerticalFlick
            clip: true


            TextEdit{
                id: textContent
                anchors.fill: parent
                anchors.rightMargin: 0.1
                anchors.bottomMargin: 0.1
                //anchors.top: parent.top
                //anchors.bottom: parent.bottom
                //anchors.left:parent.left
                //anchors.right:parent.right


                width:flickArea.width
                height:flickArea.height
                //wrapMode: TextEdit.Wrap
                text: ""

                textFormat: TextEdit.PlainText
                selectByMouse: true;
                readOnly:textshow.readonly
                font.pixelSize: 15
            }
        }*/
    }
}
