import QtQuick 1.0
 
Rectangle  {
    id: container
 
    property string text: "Button"
 
    signal clicked
 
    width: buttonLabel.width + 30; height: buttonLabel.height + 10
    border  { width: 1; color: "black" }
    smooth: true
    radius: 5
 
    // color the button with a gradient
    gradient: Gradient  {
        GradientStop  {
            position: 0.0
            color:  {
                if (mouseArea.pressed)
                    return "black"
                else
                    return "black"
            }
        }
        GradientStop  { position: 1.0; color: "black" }
    }
 
    MouseArea  {
        id: mouseArea
        anchors.fill: parent
        onClicked: container.clicked();
    }
 
    Text  {
        id: buttonLabel
        anchors.centerIn: container
        color: "white"
        text: container.text
        font.pointSize: 20; font.bold: true
    }
}
