// include PMISampleFileNameParser first

var PMIExpandSampleName = {

    expand: function(samples, row, force) {
        if (!samples) {
            console.warn('Samples object is invalid')
            return false
        }

        var sampleNameColumnIndex = -1
        var fileNameColumnIndex = -1

        var sampleNameColumnName = 'SampleName'
        var fileNameColumnName = 'SamplePath'

        // add missing columns if necessary
        for (var i = 0; i < samples.columnCount; i++) {
            if (samples.columnName(i) === fileNameColumnName) {
                fileNameColumnIndex = i
            } else if (samples.columnName(i) === sampleNameColumnName) {
                sampleNameColumnIndex = i
            }
        }

        if (fileNameColumnIndex < 0) {
            console.warn('Cannot find a column with sample files')
            return false
        }

        if (sampleNameColumnIndex < 0) {
            if (!samples.addColumn(sampleNameColumnName)) {
                return false
            }

            sampleNameColumnIndex = samples.columnCount-1
        }

        // no need to update
        if (!force && samples.value(row, sampleNameColumnIndex)) {
            return true
        }

        var parsed = PMIVendorFileName.parse(samples.value(row, fileNameColumnIndex))

        if (!parsed || parsed.length === 0) {
            return false
        }

        if (!samples.setValue(row,
                              sampleNameColumnIndex,
                              parsed.sample + '-' + (row+1) + '-' + parsed.enzymeReduction)) {
            return false
        }

        return true
    }
}
