PMI_REPORT_MODULE.scriptLoader.include("core/BrokerEventAggregatorObject.js");PMI_REPORT_MODULE.scriptLoader.include("core/ImageProxy.js");PMI_REPORT_MODULE.scriptLoader.include("core/HtmlEntityConverter.js");PMI_REPORT_MODULE.scriptLoader.include('models/FreeTextValues.js');PMI_REPORT_MODULE.scriptLoader.include('models/FreeTextValuesDAO.js');PMI_REPORT_MODULE.scriptLoader.include("core/HtmlElementsIdentifierNames.js");PMI_REPORT_MODULE.FreeTextRenderAreaViewController=function(opts={}){let m_keys=new PMI_REPORT_MODULE.HtmlElementsIdentifierNames();const m_getParentElement=opts.getParentElement;let m_mediator=opts.mediator;let m_model=opts.model;let m_freeTextValuesDAO=new PMI_REPORT_MODULE.FreeTextValuesDAO({database:m_model});const m_freeTextClassName="freeTextArea";const m_topFreeTextClassName='top'+m_freeTextClassName;const m_bottomFreeTextClassName='bottom'+m_freeTextClassName;let m_htmlEntityConverter=new PMI_REPORT_MODULE.HtmlEntityConverter();const m_freeTextAreaPadding=3;function setText(opts){let textArea=document.getElementsByClassName(opts.additionalClassName);if(textArea.length>0){textArea=textArea[0];textArea.innerHTML=plainTextToHtml(opts.text);}
if(opts.textIsEmpty){textArea.style.display='none';}}
function findElements(mainNode){let elements=[];let nodes=mainNode.childNodes;for(let i=0,size=nodes.length;i<size;++i){let node=nodes[i];if(node.nodeType===Node.TEXT_NODE||node.childElementCount===0){elements.push(node);}else{elements=elements.concat(findElements(node));}}
return elements;}
function findFreeTextContentLines(node){let contentByYPosition=new Map();let nodes=findElements(node);for(let i=0,size=nodes.length;i<size;++i){let node=nodes[i];let obj={type:'standard'};let position;let range=document.createRange();range.selectNodeContents(node);position=range.getClientRects()[0];if(!position){continue;}
let y=position.top;if(!contentByYPosition.has(y)){contentByYPosition.set(y,[]);}
if(node.tagName&&node.tagName.toLowerCase()==='img'){obj.content=node.src;obj.type=node.tagName;contentByYPosition.get(y).push(obj);}else{if(node.nodeType===Node.TEXT_NODE||node.childElementCount===0){obj.content=node.textContent;obj.type=node.tagName;contentByYPosition.get(y).push(obj);}}}
let keys=[...contentByYPosition.keys()];keys.sort(function(a,b){return a-b;});let content=[];let previous=undefined;for(let i=0,size=keys.length;i<size;++i){let key=keys[i];if(!previous||Math.abs(key-previous)>1){content.push(contentByYPosition.get(key));previous=key;}}
return content;}
function createTextArea(opts){let textArea=document.getElementsByClassName(opts.additionalClassName);if(textArea.length>0){return setText(opts);}
if(opts.textIsEmpty){return;}
textArea=document.createElement("div");textArea.classList.add(m_freeTextClassName);textArea.classList.add(opts.additionalClassName);let textAreaStyle=textArea.style;textAreaStyle.padding=m_freeTextAreaPadding+"px";textAreaStyle.wordBreak='break-word';textArea.readOnly=true;textArea.innerHTML=plainTextToHtml(opts.text);textArea.setAttribute(m_keys.renderedHtmlElementUniqueAttributeNameValue(),"true");let dropEventHandler=new PMI_REPORT_MODULE.DropEventHandler({target:textArea});dropEventHandler.init();dropEventHandler.subscribe(dropEventHandler.EVENT_TYPE.ITEM_DROPPED,function(event){let target=event.target;let file=event.dataTransfer.files[0];const reader=new FileReader();reader.onload=function(loaded){let imageProxy=new PMI_REPORT_MODULE.ImageProxy();imageProxy.subscribe(imageProxy.EVENT_TYPE.IMAGE_CREATED,function(){target.appendChild(imageProxy.resizedImage());let freeTextModel=new PMI_REPORT_MODULE.FreeTextValues();freeTextModel.fromObject(m_freeTextValuesDAO.get());opts.onDropHandler({content:textArea.innerHTML,model:freeTextModel});m_freeTextValuesDAO.set(freeTextModel);m_impl.publish(m_impl.EVENT_TYPE.ITEM_DROPPED);});let rect=target.getBoundingClientRect();imageProxy.init({width:rect.width,height:rect.height,data:loaded.target.result});};reader.readAsDataURL(file);});opts.addElement(textArea);opts.applyStyle(textAreaStyle);if(parseInt(opts.width)>1){textAreaStyle.width=opts.width;}
textAreaStyle.backgroundColor="white";textAreaStyle.border="1px solid gray";return textArea;}
function getPvtRendererAreaWidth(){let parent=m_getParentElement();if(!parent){return-1;}
let width=parent.clientWidth-(2*m_freeTextAreaPadding);let style=window.getComputedStyle(parent);let paddingValue=parseInt(style.getPropertyValue("padding-left"));if(paddingValue&&!Number.isNaN(paddingValue)){width=width-(2*paddingValue);}
return width+"px";}
function plainTextToHtml(plain){return m_htmlEntityConverter.decode(plain.replace(/\n/g,"<br>"));}
function updateGeometry(){let parent=m_getParentElement();if(!parent){return;}
let elements=document.getElementsByClassName(m_freeTextClassName);if(!elements||elements.length===0){return;}
for(let i=0,size=elements.length;i<size;++i){let freeText=elements[i];freeText.style.width="0px";}
let width=getPvtRendererAreaWidth();for(let i=0,size=elements.length;i<size;++i){let freeText=elements[i];freeText.style.width=width;}}
function setAreaDisplay(value){let areas=document.getElementsByClassName(m_freeTextClassName);for(let i=0,size=areas.length;i<size;++i){let area=areas[i];area.style.display=value;}}
function hideAreas(){setAreaDisplay('none');}
function showAreas(){setAreaDisplay('initial');}
function updateTextArea(){let freeTextModel=new PMI_REPORT_MODULE.FreeTextValues();freeTextModel.fromObject(m_freeTextValuesDAO.get());let endText=freeTextModel.textAtEnd();let startText=freeTextModel.textAtStart();const startTextIsEmpty=startText.length===0;const endTextIsEmpty=endText.length===0;if(endTextIsEmpty&&startTextIsEmpty){hideAreas();return;}
showAreas();let width=getPvtRendererAreaWidth();createTextArea({text:endText,textIsEmpty:endTextIsEmpty,width:width,additionalClassName:m_bottomFreeTextClassName,addElement:function(textArea){if(!m_getParentElement){return;}
m_getParentElement().appendChild(textArea);},applyStyle:function(textAreaStyle){textAreaStyle.marginTop="5px";},onDropHandler:function(opts){let freeTextModel=opts.model;let content=opts.content;freeTextModel.setTextAtEnd(content);}});createTextArea({text:startText,width:width,textIsEmpty:startTextIsEmpty,additionalClassName:m_topFreeTextClassName,addElement:function(textArea){if(!m_getParentElement){return;}
let parent=m_getParentElement();if(!parent){return;}
parent.insertBefore(textArea,parent.firstChild);},applyStyle:function(textAreaStyle){textAreaStyle.marginBottom="5px";},onDropHandler:function(opts){let freeTextModel=opts.model;let content=opts.content;freeTextModel.setTextAtStart(content);}});}
let GetHtmlOption={INNER_HTML:'PMI_REPORT_MODULE.FreeTextRenderAreaViewController.INNER_HTML',OUTER_HTML:'PMI_REPORT_MODULE.FreeTextRenderAreaViewController.OUTER_HTML',};Object.freeze(GetHtmlOption);function getHtml(opts){let className=opts.className;let option=opts.option;let areas=document.getElementsByClassName(className);if(areas.length===0){return'';}
let area=areas[0];if(!area){return'';}
return option===GetHtmlOption.OUTER_HTML?area.outerHTML:area.innerHTML;}
let m_impl=Object.create(new PMI_REPORT_MODULE.BrokerEventAggregatorObject());const EVENT_TYPE={CHANGE_ACCEPTED:"PMI_REPORT_MODULE.FreeTextRenderAreaViewController.ITEM_DROPPED",};Object.freeze(EVENT_TYPE);m_impl.EVENT_TYPE=EVENT_TYPE;m_impl.topFreeTextClassName=function(){return m_topFreeTextClassName;};m_impl.bottomFreeTextClassName=function(){return m_bottomFreeTextClassName;};m_impl.init=function(opts){if(!opts){console.warn('Can not find FreeTextRenderAreaViewController parameters');return;}
let createRenderAreaEvents=opts.createRenderAreaEvents;if(!createRenderAreaEvents){console.warn('Can not find createRenderAreaEvents events');return;}
for(let i=0,size=createRenderAreaEvents.length;i<size;++i){let eventName=createRenderAreaEvents[i];m_mediator.subscribe(eventName,updateTextArea);}
let geometryUpdateEvents=opts.geometryUpdateEvents;if(!geometryUpdateEvents){console.warn('Can not find geometryUpdateEvents events');}else{for(let i=0,size=geometryUpdateEvents.length;i<size;++i){let eventName=geometryUpdateEvents[i];m_mediator.subscribe(eventName,function(){updateGeometry();});}}};m_impl.topFreeTextChildren=function(){let areas=document.getElementsByClassName(m_topFreeTextClassName);if(areas.length===0){return[];}
let area=areas[0];return findFreeTextContentLines(area);};m_impl.bottomFreeTextChildren=function(){let areas=document.getElementsByClassName(m_bottomFreeTextClassName);if(areas.length===0){return[];}
let area=areas[0];return findFreeTextContentLines(area);};m_impl.topFreeTextOuterHtml=function(){return getHtml({className:m_topFreeTextClassName,option:GetHtmlOption.OUTER_HTML});};m_impl.bottomFreeTextOuterHtml=function(){return getHtml({className:m_bottomFreeTextClassName,option:GetHtmlOption.OUTER_HTML});};m_impl.topFreeTextInnerHtml=function(){return getHtml({className:m_topFreeTextClassName,option:GetHtmlOption.INNER_HTML});};m_impl.bottomFreeTextInnerHtml=function(){return getHtml({className:m_bottomFreeTextClassName,option:GetHtmlOption.INNER_HTML});};m_impl.hide=function(){hideAreas();}
m_impl.showTop=function(){let area=document.getElementsByClassName(m_topFreeTextClassName)[0];if(!area){return;}
area.style.display='initial';}
m_impl.showBottom=function(){let area=document.getElementsByClassName(m_bottomFreeTextClassName)[0];if(!area){return;}
area.style.display='initial';}
return Object.freeze(m_impl);};
//# sourceURL=FreeTextRenderAreaViewController.js