(function(global,factory){typeof exports==='object'&&typeof module!=='undefined'?factory(require('chart.js')):typeof define==='function'&&define.amd?define(['chart.js'],factory):(factory(global.Chart));}(this,(function(Chart){'use strict';Chart=Chart&&Chart.hasOwnProperty('default')?Chart['default']:Chart;var helpers$1=Chart.helpers;var defaults={align:'end',anchor:'end',backgroundColor:null,borderColor:null,borderRadius:0,borderWidth:0,color:undefined,display:true,font:{family:undefined,size:undefined,style:undefined,weight:null},lineHeight:1.2,offset:4,padding:{top:4,right:4,bottom:4,left:4},rotation:0,textAlign:'start',formatter:function(value){var label=value;var keys,klen,k;if(helpers$1.isObject(value)){if(!helpers$1.isNullOrUndef(value.label)){label=value.label;}else if(!helpers$1.isNullOrUndef(value.r)){label=value.r;}else{label='';keys=Object.keys(value);for(k=0,klen=keys.length;k<klen;++k){label+=(k!==0?', ':'')+keys[k]+': '+value[keys[k]];}}}
return''+label;}};function orient(point,origin){var x0=origin.x;var y0=origin.y;if(x0===null){return{x:0,y:-1};}
if(y0===null){return{x:1,y:0};}
var dx=point.x-x0;var dy=point.y-y0;var ln=Math.sqrt(dx*dx+dy*dy);return{x:ln?dx/ln:0,y:ln?dy/ln:-1};}
var positioners={arc:function(vm,anchor){var angle=(vm.startAngle+vm.endAngle)/2;var vx=Math.cos(angle);var vy=Math.sin(angle);var r0=vm.innerRadius;var r1=vm.outerRadius;var d;if(anchor==='start'){d=r0;}else if(anchor==='end'){d=r1;}else{d=(r0+r1)/2;}
return{x:vm.x+vx*d,y:vm.y+vy*d,vx:vx,vy:vy};},point:function(vm,anchor,origin){var v=orient(vm,origin);var r=vm.radius;var d=0;if(anchor==='start'){d=-r;}else if(anchor==='end'){d=r;}
return{x:vm.x+v.x*d,y:vm.y+v.y*d,vx:v.x,vy:v.y};},rect:function(vm,anchor,origin){var horizontal=vm.horizontal;var size=Math.abs(vm.base-(horizontal?vm.x:vm.y));var x=horizontal?Math.min(vm.x,vm.base):vm.x;var y=horizontal?vm.y:Math.min(vm.y,vm.base);var v=orient(vm,origin);if(anchor==='center'){if(horizontal){x+=size/2;}else{y+=size/2;}}else if(anchor==='start'&&!horizontal){y+=size;}else if(anchor==='end'&&horizontal){x+=size;}
return{x:x,y:y,vx:v.x,vy:v.y};},fallback:function(vm,anchor,origin){var v=orient(vm,origin);return{x:vm.x,y:vm.y,vx:v.x,vy:v.y};}};Chart.defaults.global.plugins.datalabels=defaults;var helpers=Chart.helpers;var MODEL_KEY='$datalabels';function toTextLines(inputs){var lines=[];var input;inputs=[].concat(inputs);while(inputs.length){input=inputs.pop();if(typeof input==='string'){lines.unshift.apply(lines,input.split('\n'));}else if(Array.isArray(input)){inputs.push.apply(inputs,input);}else if(!helpers.isNullOrUndef(inputs)){lines.unshift(''+input);}}
return lines;}
function toFontString(font,text){if(!font||helpers.isNullOrUndef(font.size)||helpers.isNullOrUndef(font.family)){return null;}
if(typeof font.sizeDetector==="function"){font.size=font.sizeDetector(text);}
return(font.style?font.style+' ':'')
+(font.weight?font.weight+' ':'')
+font.size+'px '
+font.family;}
function textSize(ctx,lines,font){var items=[].concat(lines);var ilen=items.length;var prev=ctx.font;var width=0;var i;for(i=0;i<ilen;++i){let text=items[i];ctx.font=font.string(font,text);width=Math.max(ctx.measureText(text).width,width);}
ctx.font=prev;return{height:ilen*font.lineHeight,width:width};}
function parseFont(value){var global=Chart.defaults.global;var size=helpers.valueOrDefault(value.size,global.defaultFontSize);var font={family:helpers.valueOrDefault(value.family,global.defaultFontFamily),lineHeight:helpers.options.toLineHeight(value.lineHeight,size),size:size,style:helpers.valueOrDefault(value.style,global.defaultFontStyle),weight:helpers.valueOrDefault(value.weight,null),string:'',sizeDetector:value.sizeDetector};font.string=toFontString;return font;}
function coordinates(el,model){var point=model.positioner(el._view,model.anchor,model.origin);if(model.align==='center'){return{x:point.x,y:point.y};}
var padding=model.padding;var rotation=model.rotation;var th=model.size.height;var tw=model.size.width;var vx=point.vx;var vy=point.vy;var dx=0;var dy=0;if(model.align==='start'){vx=-vx;vy=-vy;}
dx+=Math.abs(tw/2*Math.cos(rotation))+Math.abs(th/2*Math.sin(rotation));dy+=Math.abs(tw/2*Math.sin(rotation))+Math.abs(th/2*Math.cos(rotation));dx+=vx>0?padding.right:padding.left;dy+=vy>0?padding.bottom:padding.top;dx+=model.borderWidth||0;dy+=model.borderWidth||0;dx+=model.offset;dy+=model.offset;return{x:point.x+dx*vx,y:point.y+dy*vy};}
function boundingRects(size,padding){var th=size.height;var tw=size.width;var tx=-tw/2;var ty=-th/2;return{frame:{x:tx-padding.left,y:ty-padding.top,w:tw+padding.width,h:th+padding.height,},text:{x:tx,y:ty,w:tw,h:th}};}
function drawFrame(ctx,rect,model){var bgColor=model.backgroundColor;var borderColor=model.borderColor;var borderWidth=model.borderWidth;if(!bgColor&&(!borderColor||!borderWidth)){return;}
ctx.beginPath();helpers.canvas.roundedRect(ctx,Math.round(rect.x)-borderWidth/2,Math.round(rect.y)-borderWidth/2,Math.round(rect.w)+borderWidth,Math.round(rect.h)+borderWidth,model.borderRadius);ctx.closePath();if(bgColor){ctx.fillStyle=bgColor;ctx.fill();}
if(borderColor&&borderWidth){ctx.strokeStyle=borderColor;ctx.lineWidth=borderWidth;ctx.lineJoin='miter';ctx.stroke();}}
function drawText(ctx,lines,rect,model){var align=model.textAlign;var font=model.font;var lh=font.lineHeight;var color=model.color;var ilen=lines.length;var x,y,i;if(!ilen||!color){return;}
x=rect.x;y=rect.y+lh/2;if(align==='center'){x+=rect.w/2;}else if(align==='end'||align==='right'){x+=rect.w;}
let fontRef=model.font;ctx.fillStyle=color;ctx.textAlign=align;ctx.textBaseline='middle';for(i=0;i<ilen;++i){let value=lines[i];ctx.font=fontRef.string(fontRef,value);ctx.fillText(value,Math.round(x),Math.round(y),Math.round(rect.w));y+=lh;}}
function getPositioner(el){if(el instanceof Chart.elements.Arc){return positioners.arc;}
if(el instanceof Chart.elements.Point){return positioners.point;}
if(el instanceof Chart.elements.Rectangle){return positioners.rect;}
return positioners.fallback;}
function getScaleOrigin(el){var horizontal=el._model.horizontal;var scale=el._scale||(horizontal&&el._xScale)||el._yScale;if(!scale){return null;}
if(scale.xCenter!==undefined&&scale.yCenter!==undefined){return{x:scale.xCenter,y:scale.yCenter};}
var pixel=scale.getBasePixel();return horizontal?{x:pixel,y:null}:{x:null,y:pixel};}
function modelize(el,index,ctx,config,context){var resolve=Chart.helpers.options.resolve;if(!resolve([config.display,true],context,index)){return null;}
var value=context.dataset.data[index];var label=helpers.valueOrDefault(helpers.callback(config.formatter,[value,context]),value);var lines=helpers.isNullOrUndef(label)?[]:toTextLines(label);if(!lines.length){return null;}
var font=parseFont(resolve([config.font,{}],context,index));var model={align:resolve([config.align,'center'],context,index),anchor:resolve([config.anchor,'center'],context,index),backgroundColor:resolve([config.backgroundColor,null],context,index),borderColor:resolve([config.borderColor,null],context,index),borderRadius:resolve([config.borderRadius,0],context,index),borderWidth:resolve([config.borderWidth,0],context,index),color:resolve([config.color,Chart.defaults.global.defaultFontColor],context,index),font:font,lines:lines,offset:resolve([config.offset,0],context,index),padding:helpers.options.toPadding(resolve([config.padding,0],context,index)),rotation:resolve([config.rotation,0],context,index)*(Math.PI/180),textAlign:resolve([config.textAlign,'start'],context,index),origin:getScaleOrigin(el),positioner:getPositioner(el),size:textSize(ctx,lines,font)};return model;}
function configure(dataset,options){var override=dataset.datalabels;var config={};if(override===false){return null;}
if(override===true){override={};}
return helpers.merge(config,[options,override]);}
Chart.pluginService.register({id:'datalabels',afterDatasetUpdate:function(chart,args,options){var dataset=chart.data.datasets[args.index];var config=configure(dataset,options);var display=config&&config.display;var elements=args.meta.data||[];var ilen=elements.length;var ctx=chart.ctx;var i,el;ctx.save();for(i=0;i<ilen;++i){el=elements[i];el[MODEL_KEY]=display&&el&&!el.hidden?modelize(el,i,ctx,config,{chart:chart,dataIndex:i,dataset:dataset,datasetIndex:args.index}):null;}
ctx.restore();},afterDatasetDraw:function(chart,args){var elements=args.meta.data||[];var ilen=elements.length;var ctx=chart.ctx;var i,el,model,center,rects;var dataset=chart.data.datasets[args.index];for(i=0;i<ilen;++i){el=elements[i];model=el[MODEL_KEY];if(!model){continue;}
center=coordinates(el,model);rects=boundingRects(model.size,model.padding);let yPosition=0;if(dataset.error){try{const horizontal=chart.config.type==='horizontalBar';const vScale=horizontal?chart.scales['x-axis-0']:chart.scales['y-axis-0'];const index=el._index;const dataValue=dataset.data[index];const errorValue=dataset.error[index];yPosition=vScale.getPixelForValue(dataValue+errorValue)-model.size.height/2;}catch(error){console.log(error);yPosition=center.y;}}
ctx.save();ctx.translate(Math.round(center.x),Math.round(yPosition));ctx.rotate(model.rotation);drawFrame(ctx,rects.frame,model);drawText(ctx,model.lines,rects.text,model);ctx.restore();}}});})));
//# sourceURL=ChartCustomLabels.js