PMI_REPORT_MODULE.scriptLoader.include("widgets/widgetsFactory.js");PMI_REPORT_MODULE.scriptLoader.include("summaryTab/core/ProjectOptionsTableTextColorChanger.js");PMI_REPORT_MODULE.scriptLoader.include("summaryTab/views/projectTableColumnVisibilityPresenter.js");PMI_REPORT_MODULE.scriptLoader.include("summaryTab/controllers/summaryTabEventAggregator.js");PMI_REPORT_MODULE.scriptLoader.include("summaryTab/models/SummaryTabSettingsKeys.js");PMI_REPORT_MODULE.scriptLoader.include("jsCppBridge/ReportStringConstants.js");PMI_REPORT_MODULE.scriptLoader.include("core/PromiseChecker.js");window.projectTableOptionsUiController=(function(){const m_projectTableOptionsKey='projectTableOptions';let m_settingsKeys=new PMI_REPORT_MODULE.SummaryTabSettingsKeys();let m_reportStringConstants=new PMI_REPORT_MODULE.ReportStringConstants();async function updateTables(configuration){let projectTableOption=readProjectTableOption(configuration);let colorText=configuration[m_settingsKeys.colorCodeSampleNameInProjectTableKey];updateDialogUiElements(projectTableOption);await updateProjectTables(configuration,projectTableOption,colorText);updateProjectTableOptionsVisibility();}
summaryTabEventAggregator.subscribe(summaryTabEventAggregator.EVENT_TYPE.TAB_SETTINGS_INITIALIZED,function(data){updateTables(data.configuration);});summaryTabEventAggregator.subscribe(summaryTabEventAggregator.EVENT_TYPE.CURRENT_TAB_SETTINGS_CHANGED,function(configuration){updateTables(configuration);});summaryTabEventAggregator.subscribe(summaryTabEventAggregator.EVENT_TYPE.INIT_CUSTOMIZED_COLUMNS_REQUIRED,function(data){let previousOption=data.previousOption;let configuration=data.configuration;const columnsToShow=visibleCellsGetter(previousOption)(getProjectTableElements()[0],configuration);summaryTabEventAggregator.publish(summaryTabEventAggregator.EVENT_TYPE.ABOUT_TO_INIT_CUSTOMIZED_COLUMNS,columnsToShow);});summaryTabEventAggregator.subscribe(summaryTabEventAggregator.EVENT_TYPE.SETTINGS_DIALOG_INITIALIZED,async function(){let fieldSet=document.getElementById(m_projectTableOptionsKey);if(!fieldSet){console.warn('Project table options does not exist');return;}
let optionsForm=fieldSet.getElementsByTagName('form')[0];if(!optionsForm){console.warn('Project table form options does not exist');return;}
const radioButtonSettings=[{id:m_settingsKeys.showPredefinedColumnsKey,description:'Show predefined columns'+' ('+await crossCuttingLayer.javaScriptHelper.projectTableOptionsPredefinedColumns()+')',defaultValue:false,name:m_projectTableOptionsKey,value:m_settingsKeys.showPredefinedColumnsKey},{id:m_settingsKeys.showVisibleColumnsKey,description:'Show columns visible in application project table',defaultValue:true,name:m_projectTableOptionsKey,value:m_settingsKeys.showVisibleColumnsKey},{id:m_settingsKeys.showCustomizedColumnsKey,description:'Show customized columns',defaultValue:false,name:m_projectTableOptionsKey,value:m_settingsKeys.showCustomizedColumnsKey}];for(let i=0,size=radioButtonSettings.length;i<size;++i){let settings=radioButtonSettings[i];let option=PMI_REPORT_MODULE.widgetsFactory.createRadioButton(optionsForm,settings);option._label.classList.add('disabletextselection');option.value=settings.value;optionsForm.appendChild(document.createElement('br'));}
optionsForm.addEventListener('change',function(event){summaryTabEventAggregator.publish(summaryTabEventAggregator.EVENT_TYPE.ON_PROJECT_TABLE_OPTIONS_CHANGED,event.target.value);});});function getProjectTableElements(){return document.getElementsByClassName(m_reportStringConstants.projectTableShortCodeName());}
async function updateProjectTables(configuration,projectTableOption,colorText){let columnsToShow=undefined;let projectTableElements=getProjectTableElements();let cellsIndexToShow=undefined;let checker=new PMI_REPORT_MODULE.PromiseChecker();if(checker.isPromise(configuration)){configuration=await configuration();}
for(let i=0;i<projectTableElements.length;++i){let projectTable=projectTableElements[i];columnsToShow=await visibleCellsGetter(projectTableOption)(projectTable,configuration);let changer=new HTMLTableColumnsChanger(projectTable,columnsToShow);await changer.changeColumnsOrder();let colorChanger=new ProjectOptionsTableTextColorChanger(projectTable,colorText);colorChanger.changeTextColor();if(cellsIndexToShow===undefined){cellsIndexToShow=listOfCellsToShow(projectTable,columnsToShow);}
showCells(cellsIndexToShow,projectTable);}}
function updateDialogUiElements(projectTableOption){let optionElement=document.getElementById(projectTableOption);if(optionElement){optionElement.checked=true;}}
function readProjectTableOption(configuration){let columnVisibilityOptionKey=m_settingsKeys.projectTableColumnVisibilityKey;let projectTableOption=configuration?configuration[columnVisibilityOptionKey]:configuration;if(!projectTableOption){projectTableOption=document.querySelector('input[name="'+m_projectTableOptionsKey+'"]:checked').value;}
return projectTableOption;}
function updateProjectTableOptionsVisibility(){const projectTableExist=document.getElementsByClassName(m_reportStringConstants.projectTableShortCodeName()).length>0;if(projectTableExist){document.getElementById(m_projectTableOptionsKey).style.display='block';}else{document.getElementById(m_projectTableOptionsKey).style.display='none';summaryTabEventAggregator.publish(summaryTabEventAggregator.EVENT_TYPE.HIDE_PROJECT_TABLE_OPTIONS);}}
function visibleCellsGetter(projectTableOption){if(!visibleCellsGetter.getters){visibleCellsGetter.getters={};visibleCellsGetter.getters[m_settingsKeys.showVisibleColumnsKey]=async function(projectTable,configuration){const key=await crossCuttingLayer.javaScriptHelper.applicationVisibleProjectTableColumnsKey();return new Promise(function(resolve,reject){return resolve(JSON.parse(projectTable.getAttribute(key)));});};visibleCellsGetter.getters[m_settingsKeys.showPredefinedColumnsKey]=async function(projectTable,configuration){const visiblePredefinedColumns=[];const predefinedColumns=await crossCuttingLayer.javaScriptHelper.projectTableOptionsPredefinedColumns();const columnVisibilityRepository=new ProjectTableColumnVisibilityRepository();const columnsFromApplication=columnVisibilityRepository.applicationColumnNames(projectTable);for(let i=0,size=predefinedColumns.length;i<size;++i){let predefinedColumn=predefinedColumns[i];if(columnsFromApplication.includes(predefinedColumn)){visiblePredefinedColumns.push(predefinedColumn);}}
return new Promise(function(resolve,reject){return resolve(visiblePredefinedColumns);});};visibleCellsGetter.getters[m_settingsKeys.showCustomizedColumnsKey]=async function(projectTable,configuration){if(!configuration){console.warn('configuration data is empty');return;}
let visibleColumns=[];const visibility=configuration[m_settingsKeys.customizedColumnsKey];if(!visibility){return;}
for(let i=0,size=visibility.length;i<size;++i){let obj=new ProjectTableColumnVisibility();obj.fromObject(visibility[i]);const columnName=obj.columnName();if(obj.visible()===true){visibleColumns.push(columnName);}}
return new Promise(function(resolve,reject){return resolve(visibleColumns);});};}
return visibleCellsGetter.getters[projectTableOption];}
function showCells(indexOfCellsToShow,projectTable){let rows=projectTable.rows;for(var i=0;i<rows.length;++i){for(var j=0;j<rows[i].cells.length;++j){var cell=rows[i].cells[j];cell.style.display="";if(indexOfCellsToShow.indexOf(j)===-1){cell.style.display="none";}}}}
function listOfCellsToShow(projectTable,columnsToShow){var cellIndexes=[];var headers=projectTable?.rows[0]?.cells;for(var i=0;i<headers?.length;++i){var headerName=headers[i].innerText;if(columnsToShow.indexOf(headerName)!==-1){cellIndexes.push(headers[i].cellIndex);}}
return cellIndexes;}
return{onShowDialog:function(configuration){let projectTableOption=readProjectTableOption(configuration);updateDialogUiElements(projectTableOption);updateProjectTableOptionsVisibility();},onChangeAccepted:function(){if(m_projectTableOptionsKey){summaryTabConfigurationData.setValue(m_settingsKeys.projectTableColumnVisibilityKey,document.querySelector('input[name="'+m_projectTableOptionsKey+'"]:checked').value);summaryTabConfigurationData.getConfiguration()?.then(function(configuration){updateTables(configuration);});}}};})();
//# sourceURL=projectTableOptionsUiController.js