PMI_REPORT_MODULE.scriptLoader.include("pivotTab/models/AxisSettingsRepository.js");PMI_REPORT_MODULE.scriptLoader.include('pivotTab/renderEngine/LogarithmicScale.js');PMI_REPORT_MODULE.scriptLoader.include("vendor/d3.js");PMI_REPORT_MODULE.VolcanoPlotView=function(){'use strict';let m_container=null;let m_sizeCalculator=new RenderedContentSizeCalculator();let m_foldChangeThreshold;let m_significanceThreshold;const m_xAxisLabelText='fold change';const m_yAxisLabelText='p-value';const m_defaultSize={width:800,height:600};function addSignificanceThresholdLines(opts){const significanceThreshold=opts.significanceThreshold;const yPosition=opts.yScale(opts.significanceThreshold);const foldThreshold=opts.foldThreshold;opts.svg.append("line").attr("class","volcanoThresholdLine").attr("x1",0).attr("x2",opts.innerWidth).attr("y1",yPosition).attr("y2",yPosition);opts.svg.append("text").attr("class","volcanoThresholdText").attr("x",-5).attr("y",yPosition).attr("fill","red").text(`q = ${significanceThreshold}`).style("text-anchor","end");let lines=[foldThreshold,-1*foldThreshold];let xScaleRange=opts.xScale.domain();const minX=xScaleRange[0];const maxX=xScaleRange[1];for(let i=0,size=lines.length;i<size;++i){const threshold=lines[i];if(threshold<minX||threshold>maxX){continue;}
opts.svg.append("line").attr("class","volcanoThresholdLine").attr("x1",opts.xScale(threshold)).attr("x2",opts.xScale(threshold)).attr("y1",0).attr("y2",opts.innerHeight);}}
function VolcanoPlot(){var width=m_defaultSize.width,height=m_defaultSize.height,margin={top:5,right:10,bottom:50,left:60},xColumn,yColumn,xAxisLabel,yAxisLabel,xAxisLabelOffset,yAxisLabelOffset,xTicks,yTicks,sampleID="Gene",colorRange,xScale=d3.scaleLinear(),yScale=d3.scaleLog();function chart(selection){var innerWidth=width-margin.left-margin.right,innerHeight=height-margin.top-margin.bottom;selection.each(function(data){xScale.range([0,innerWidth]).domain(d3.extent(data,function(d){return d.log2FoldChange();})).nice();yScale.range([0,innerHeight]).domain(d3.extent(data,function(d){return d.pValue();})).nice();var svg=d3.select(this).append('svg').attr('height',height).attr('width',width).append('g').attr('transform','translate('+margin.left+','+margin.top+')');svg.append('defs').append('clipPath').attr('id','clip').append('rect').attr('height',innerHeight).attr('width',innerWidth);var xAxis=d3.axisBottom(xScale);var yAxis=d3.axisLeft(yScale).ticks(5).tickFormat(yTickFormat);var gX=svg.append('g').attr('class','x axis').attr('transform','translate(0,'+innerHeight+')').call(xAxis);gX.append('text').attr('class','volcanoAxisLabel').attr('transform','translate('+((width/2))+','+(margin.bottom-20)+')').attr('text-anchor','middle').html(xAxisLabel||xColumn);var gY=svg.append('g').attr('class','y axis').call(yAxis);gY.append('text').attr('class','volcanoAxisLabel').attr('transform','translate('+(0-margin.left/1.15)+','+(height/2)+') rotate(-90)').style('text-anchor','middle').html(yAxisLabel||yColumn);var circles=svg.append('g').attr('class','circlesContainer');circles.selectAll(".dot").data(data).enter().append('circle').attr('r',3).attr('cx',function(d){return xScale(d.log2FoldChange());}).attr('cy',function(d){return yScale(d.pValue());}).attr('class',circleClass).on('mouseenter',tipEnter).on("mousemove",tipMove).on('mouseleave',function(d){return tooltip.style('visibility','hidden');});addSignificanceThresholdLines({svg:svg,yScale:yScale,significanceThreshold:m_significanceThreshold,innerWidth:innerWidth,foldThreshold:m_foldChangeThreshold,xScale:xScale,innerHeight:innerHeight});var tooltip=d3.select(m_container).append("div").attr('class','volcanoTooltip');function tipEnter(d){tooltip.style('visibility','visible').style('font-size','11px').html('<strong>'+sampleID+'</strong>: '+d.dataName()+'<br/>'+'<strong>'+xColumn+'</strong>: '+d3.format('.2f')(d.log2FoldChange())+'<br/>'+'<strong>'+yColumn+'</strong>: '+d.pValue());}
function tipMove(){let node=tooltip.node();tooltip.style("top",(event.pageY-parseInt(node.offsetHeight))+"px").style("left",(event.pageX-parseInt(node.offsetWidth))+"px");}
function yTickFormat(n){return d3.format(".2r")(-getBaseLog(10,n));function getBaseLog(x,y){return Math.log(y)/Math.log(x);}}
function circleClass(d){if(d.pValue()<=m_significanceThreshold&&Math.abs(d.log2FoldChange())>=m_foldChangeThreshold)return'volcanoDot sigfold';else if(d.pValue()<=m_significanceThreshold)return'volcanoDot sig';else if(Math.abs(d.log2FoldChange())>=m_foldChangeThreshold)return'volcanoDot fold';else return'volcanoDot';}});}
chart.width=function(value){if(!arguments.length)return width;width=value;return chart;};chart.height=function(value){if(!arguments.length)return height;height=value;return chart;};chart.margin=function(value){if(!arguments.length)return margin;margin=value;return chart;};chart.xColumn=function(value){if(!arguments.length)return xColumn;xColumn=value;return chart;};chart.yColumn=function(value){if(!arguments.length)return yColumn;yColumn=value;return chart;};chart.xAxisLabel=function(value){if(!arguments.length)return xAxisLabel;xAxisLabel=value;return chart;};chart.yAxisLabel=function(value){if(!arguments.length)return yAxisLabel;yAxisLabel=value;return chart;};chart.xAxisLabelOffset=function(value){if(!arguments.length)return xAxisLabelOffset;xAxisLabelOffset=value;return chart;};chart.yAxisLabelOffset=function(value){if(!arguments.length)return yAxisLabelOffset;yAxisLabelOffset=value;return chart;};chart.xTicks=function(value){if(!arguments.length)return xTicks;xTicks=value;return chart;};chart.yTicks=function(value){if(!arguments.length)return yTicks;yTicks=value;return chart;};chart.significanceThreshold=function(value){if(!arguments.length)return m_significanceThreshold;m_significanceThreshold=value;return chart;};chart.foldChangeThreshold=function(value){if(!arguments.length)return m_foldChangeThreshold;m_foldChangeThreshold=value;return chart;};chart.colorRange=function(value){if(!arguments.length)return colorRange;colorRange=value;return chart;};chart.sampleID=function(value){if(!arguments.length)return sampleID;sampleID=value;return chart;};return chart;}
function createInternal(opts){m_foldChangeThreshold=opts.foldChangeThreshold;m_significanceThreshold=opts.significanceThreshold;var yLabel=`-log<tspan baseline-shift="sub">10</tspan>${m_yAxisLabelText}`,xLabel=`log<tspan baseline-shift="sub">2</tspan>${m_xAxisLabelText}`;if(!m_container){m_container=document.createElement('div');m_container.id=renderTypes.plotContainerId;}
m_container.innerHTML='';let size=m_sizeCalculator.getDesiredSizeToFitWindow(renderTypes.plotContainerId);if(!size){size=m_defaultSize;}
let data=opts.data;if(!data||data.length===0){console.warn('Nothing to be show on Volcano plot');return m_container;}
var volcanoPlot=VolcanoPlot().xAxisLabel(xLabel).yAxisLabel(yLabel).foldChangeThreshold(m_foldChangeThreshold).sampleID(data[0].dataNameKey()).xColumn("log2(fold_change)").yColumn("pValue").width(size.width).height(size.height);d3.select(m_container).data([opts.data]).call(volcanoPlot);return m_container;}
return Object.freeze({create:function(opts){return createInternal(opts);},recreate:function(opts){return createInternal(opts);},});};
//# sourceURL=VolcanoPlotView.js