PMI_REPORT_MODULE.scriptLoader.include("core/ArrayRangeDetector.js");PMI_REPORT_MODULE.scriptLoader.include("pivotTab/renderEngine/PCA/pcaSvdEigenComparator.js");PMI_REPORT_MODULE.scriptLoader.include("pivotTab/renderEngine/PCA/pcaValueConverter.js");PMI_REPORT_MODULE.scriptLoader.include("vendor/d3.js");PMI_REPORT_MODULE.scriptLoader.include("vendor/numeric.js");window.pcaCalculator=(function(){var m_observationNames=[];var m_attributeNames=[];var m_lastMatrix=[];var m_dataChanged=true;let m_eigenvalues=[];var cloneArray=function(array){var clonedArray=[];for(var i=0;i<array.length;++i){clonedArray[i]=[];var row=array[i];for(var j=0;j<row.length;++j){clonedArray[i][j]=row[j];}}
return clonedArray;};var compareMatrices=function(a,b){if(a.length!==b.length){return false;}
for(let i=0;i<a.length;++i){var aRow=a[i];var bRow=b[i];if(aRow.length!==bRow.length){return false;}
for(let j=0;j<aRow.length;++j){if(aRow[j]!==bRow[j]){return false;}}}
return true;};var transposeMatrix=function(matrix){if(!matrix||!matrix[0]){return[];}
return d3.range(matrix[0].length).map(function(i){return matrix.map(function(row){return row[i];});});};var calculateMatrixMean=function(matrix){var transposedMatrix=transposeMatrix(matrix);const length=matrix.length;return transposedMatrix.map(function(row){return d3.sum(row)/length;});};var std=function(X){var m=calculateMatrixMean(X);return sqrt(calculateMatrixMean(matrixMultiplication(X,X)),matrixMultiplication(m,m));};var sqrt=function(V){return V.map(function(x){return Math.sqrt(x);});};var matrixMultiplication=function(X,Y){return d3.zip(X,Y).map(function(v){if(typeof(v[0])=='number')return v[0]*v[1];return d3.zip(v[0],v[1]).map(function(w){return w[0]*w[1];});});};var div=function(x,y){console.assert(x.length==y.length,'dim(x) == dim(y)');return d3.zip(x,y).map(function(v){return v[1]>0?v[0]/v[1]:0;});};var matrixSubtraction=function(x,y){console.assert(x.length==y.length,'dim(x) == dim(y)');return d3.zip(x,y).map(function(v){if(typeof(v[0])=='number')return v[0]-v[1];else return d3.zip(v[0],v[1]).map(function(w){return w[0]-w[1];});});};var scale=function(X,center,scale){if(center){var m=calculateMatrixMean(X);X=X.map(function(row){return matrixSubtraction(row,m);});}
if(scale){var s=std(X);X=X.map(function(row){return div(row,s);});}
return X;};var dot=function(X,Y){return numeric.dot(X,Y);};var diagonal=function(matrix){return numeric.diag(matrix);};var renderMatrix=function(data){var matrix=[];m_observationNames=[];m_attributeNames=[];if(!data){return matrix;}
var firstRow=data[0];if(!firstRow){return matrix;}
m_attributeNames=Object.keys(data[0]).filter(function(value){return value!==pcaValueConverter.observationNameKey;});for(let i=0;i<data.length;++i){m_observationNames.push(data[i][pcaValueConverter.observationNameKey]);}
for(let i=0;i<data.length;++i){var obj=data[i];matrix[i]=[];for(let j=0;j<m_attributeNames.length;++j){matrix[i][j]=obj[m_attributeNames[j]];}}
matrix=scale(matrix,true,true);return matrix;};return{createPCAMatrix:function(data){var matrix=renderMatrix(data);m_dataChanged=true;if(compareMatrices(matrix,m_lastMatrix)){m_dataChanged=false;return[];}
m_lastMatrix=cloneArray(matrix);var USV=SVD(matrix);if(!USV){return undefined;}
var U=USV.U;m_eigenvalues=USV.S;var S=diagonal(m_eigenvalues);var V=USV.V;var pcUdS=dot(U,S);if(USV.matrixTransposed===false&&!pcaSvdEigenComparator.areSvdAndEigenEqual(dot(matrix,V),pcUdS)){console.log('SVD and eigen values are not equal !');}
return[pcUdS,V];},matrixSubtraction:matrixSubtraction,attributeNames:function(){return m_attributeNames;},observationNames:function(){return m_observationNames;},dataChanged:function(){return m_dataChanged;},correlationPercentage:function(dataIndex){const rangeDetector=new PMI_REPORT_MODULE.ArrayRangeDetector(m_eigenvalues);const sum=rangeDetector.sum();const value=m_eigenvalues[dataIndex];if(!sum||!value){return 0;}
return(value/sum)*100.00;}}})();
//# sourceURL=pcaCalculator.js