PMI_REPORT_MODULE.scriptLoader.include("core/ObjectDeepCopyCreator.js");PMI_REPORT_MODULE.scriptLoader.include("core/ArrayRangeDetector.js");PMI_REPORT_MODULE.scriptLoader.include('pivotTab/renderEngine/LogarithmicScale.js');PMI_REPORT_MODULE.LogarithmicTickValuesRepository=function(){'use strict';let m_sourceArray=null;let m_deepCopyCreator=new PMI_REPORT_MODULE.ObjectDeepCopyCreator();let m_fromMaxToMin=1;let m_minimum=0;let m_maximum=0;let m_rawValues=[];const formatLogValue=typeof d3!=="undefined"?function(value){return Number(d3.format(".12~r")(value));}:function(value){return Number(value);};function formatRawValue(value){return Number(d3.format(".14~r")(value));}
let m_logScale=new PMI_REPORT_MODULE.LogarithmicScale();m_logScale.setFormatValue(formatRawValue);const m_minNumberOfRangeElements=14;function fillNotExistedPositiveValues(opts){let end=opts.end;let values=opts.values;for(let i=0;i<=end;++i){if(!values.includes(i)&&isInsideRange(i,opts)){values.push(i);}}}
function fillNotExistedNegativeValues(opts){let end=opts.end;let values=opts.values;for(let i=end;i<=0;++i){if(!values.includes(i)&&isInsideRange(i,opts)){values.push(i);}}}
function fillNotExistedValues(opts){let end=opts.end;if(end>=0){fillNotExistedPositiveValues(opts);}else{fillNotExistedNegativeValues(opts);}}
let ToRawValueOption=Object.freeze({MIN:'ToRawValueOption.MIN',MAX:'ToRawValueOption.MAX',NONE:'ToRawValueOption.NONE'});function toRawValue(opts){let logValue=opts.logValue,option=opts.option;let roundingFunction=Math.round;let rawValue=m_logScale.logToRaw(logValue,formatRawValue);if(rawValue<1){return rawValue;}
if(option===ToRawValueOption.MIN){roundingFunction=Math.floor;}else if(option===ToRawValueOption.MAX){roundingFunction=Math.ceil;}else if(option===ToRawValueOption.NONE){roundingFunction=function(value){return value;}}
return roundingFunction(rawValue);}
function roundLogValue(logValue){return Number(formatLogValue(logValue));}
function getRangeRawDifference(opts){let min=toRawValue({logValue:opts.min,option:ToRawValueOption.NONE});let max=toRawValue({logValue:opts.max,option:ToRawValueOption.NONE});return max-min;}
function detectTickStep(opts){let difference=getRangeRawDifference(opts);let numberOfDigits=String(difference).length;let divisor=Math.pow(10,numberOfDigits);if(difference===0){return 0;}
while((difference/divisor)<1){--numberOfDigits;divisor=Math.pow(10,numberOfDigits);if(divisor<Math.pow(10,-13)){break;}}
return divisor;}
function detectIndex(sourceData){if(isNaN(sourceData[0])){return 1;}
return 0;}
function isInsideRange(value,opts){let roundedLog=roundLogValue(value);return roundedLog>=roundLogValue(opts.min)&&roundedLog<=roundLogValue(opts.max);}
function getTickAllowedScale(){let ratio=0.03;return(ratio*m_fromMaxToMin);}
function isDifferenceAcceptable(opts){let first=opts.newValue;let second=opts.currentValue;return Math.abs(first-second)<getTickAllowedScale();}
function isValueDifferenceLessThanDivisor(opts){for(let i=0,size=opts.range.length;i<size;++i){if(isDifferenceAcceptable({newValue:opts.newValue,currentValue:opts.range[i]})){return true;}}
return false;}
function getRoundedValue(logValue,option){let rawValue=toRawValue({logValue:logValue,option:option});let step=Math.pow(10,Math.floor(logValue)-1);if(option===ToRawValueOption.MIN){rawValue=Math.floor(rawValue/step)*step;}else if(option===ToRawValueOption.MAX){rawValue=Math.ceil(rawValue/step)*step;}
if(rawValue===0){return logValue;}
return rawValue;}
function initRawValuesArrayAndInitRangeArrayWithRoundedLog10Values(opts){m_rawValues=[];let range=opts.range;for(let i=detectIndex(m_sourceArray),size=m_sourceArray.length;i<size;++i){let logValue=m_sourceArray[i];let rawValue=toRawValue({logValue:logValue});m_rawValues.push(rawValue);let value=Math.round(logValue);fillNotExistedValues({end:value,values:range,min:opts.min,max:opts.max});}
initMaxAndMinValues(opts);return opts;}
function addToRoundedTickValues(opts,type,divisor,roundedTickValues){let multiplier=Math.pow(10,Math.floor(opts.min));let raw=toRawValue({logValue:opts[type],option:ToRawValueOption.NONE});if(divisor>=1){raw=Math.round(raw);}
raw=raw/multiplier;opts[type]=rawToLog(raw*multiplier);roundedTickValues[type]=raw;roundedTickValues.unshift(raw);}
function shouldUseValue(logValue,type,opts){function shouldAddToRange(opts){if(opts.range.includes(opts.logValue)){return false;}
return!isValueDifferenceLessThanDivisor({newValue:opts.logValue,range:opts.range});}
return isDifferenceAcceptable({newValue:logValue,currentValue:opts[type]})&&shouldAddToRange({logValue:logValue,range:opts.range});}
function initMin(opts,roundedTickValues,divisor){let range=opts.range;let roundedMin=Math.round(opts.min);if(isDifferenceAcceptable({newValue:roundedMin,currentValue:opts.min})){if(!range.includes(roundedMin)){range.unshift(roundedMin);if(roundedMin<opts.min){opts.min=roundedMin;}}}else{let roundedRawValue=getRoundedValue(opts.min,ToRawValueOption.MIN);let multiplier=Math.pow(10,Math.floor(opts.min));roundedRawValue=(roundedRawValue/multiplier);let logValue=roundLogValue(rawToLog(roundedRawValue*multiplier));if(shouldUseValue(logValue,'min',opts)){if(logValue<opts.min){opts.min=logValue;}
roundedTickValues['min']=roundedRawValue;roundedTickValues.unshift(roundedRawValue);}else{addToRoundedTickValues(opts,'min',divisor,roundedTickValues);}}}
function initMax(opts,roundedTickValues,divisor){let range=opts.range;let roundedMax=Math.ceil(opts.max);if(isDifferenceAcceptable({newValue:roundedMax,currentValue:opts.max})){if(!range.includes(roundedMax)){range.push(roundedMax);if(roundedMax>opts.max){opts.max=roundedMax;}}}else{let roundedRawValue=getRoundedValue(opts.max,ToRawValueOption.MAX);let roundedTick=(roundedRawValue/divisor);roundedRawValue=roundedTick*divisor;let logValue=roundLogValue(rawToLog(roundedRawValue));if(shouldUseValue(logValue,'max',opts)){if(logValue>opts.max){opts.max=logValue;}
roundedTickValues['max']=roundedRawValue;roundedTickValues.push(roundedTick);}else{addToRoundedTickValues(opts,'max',divisor,roundedTickValues);}}}
function initMaxAndMinValues(opts){const divisor=detectTickStep(opts);let roundedTickValues=[];initMin(opts,roundedTickValues,divisor);initMax(opts,roundedTickValues,divisor);let maxReplacedByMin=false;const roundedTickMin=roundedTickValues['min'];if(roundedTickMin!==undefined){let maxMinValueLog=rawToLog(roundedTickMin*Math.pow(10,Math.floor(opts.max)));if(maxMinValueLog>opts.max&&isDifferenceAcceptable({currentValue:opts.max,newValue:maxMinValueLog})){opts.max=maxMinValueLog;maxReplacedByMin=true;}}
const roundedTickMax=roundedTickValues['max'];if(roundedTickMax!==undefined&&!maxReplacedByMin){let minMaxValueLog=rawToLog(roundedTickMax/Math.pow(10,(Math.floor(opts.max)-Math.floor(opts.min))));if(minMaxValueLog<opts.min&&isDifferenceAcceptable({currentValue:opts.min,newValue:minMaxValueLog})){opts.min=minMaxValueLog;}}
for(let i=0,size=roundedTickValues.length;i<size;++i){let roundedTick=roundedTickValues[i];sortRange(opts.range);extendRangeInternal(opts,function(multiplier){let value=roundedTick*multiplier;return rawToLog(value);});}
sortRange(opts.range);}
function sortRange(range){range.sort(function(a,b){return a-b;});}
function rawToLog(value){return roundLogValue(m_logScale.rawToLog(value));}
function extendRangeByMiddleTenMultiplierValues(opts){sortRange(opts.range);return extendRangeInternal(opts,function(multiplier){let value=(multiplier*10)/2;return rawToLog(value);});}
function extendRangeByMiddleValues(opts){sortRange(opts.range);let range=opts.range;const minStartValue=Math.floor(opts.min);const minAndMaxTick=2;const expectedMiddleTick=2;let roundedValues=[];if(range.length===0||range.length>minAndMaxTick){return;}
let allowedAttempt=100;while((range.length<(expectedMiddleTick+minAndMaxTick))){for(let i=0,size=range.length-1;i<size;++i){const firstValue=toRawValue({logValue:range[i]-minStartValue,option:ToRawValueOption.NONE});const secondValue=toRawValue({logValue:range[i+1]-minStartValue,option:ToRawValueOption.NONE});let value=((secondValue+firstValue)/2);extendRangeInternal(opts,function(multiplier){let logValue=rawToLog(value*multiplier);roundedValues.push(logValue);return logValue;});}
--allowedAttempt;sortRange(range);if(allowedAttempt===0){break;}}
let rawDifference=getRangeRawDifference(opts);for(let i=0,size=range.length;i<size;++i){let value=range[i];let raw=toRawValue({logValue:value,option:ToRawValueOption.NONE});if(rawDifference>expectedMiddleTick&&roundedValues.includes(value)){raw=Math.round(raw);range[i]=rawToLog(raw);}}}
function extendRange(opts){let range=opts.range;const divisor=detectTickStep(opts);if(range.length>=m_minNumberOfRangeElements){return range;}
let decorators=[extendRangeByMiddleTenMultiplierValues,extendRangeByMiddleValues];for(let i=0,size=decorators.length;i<size;++i){decorators[i]({divisor:divisor,range:range,min:opts.min,max:opts.max});if(range.length>=m_minNumberOfRangeElements){break;}}
return range;}
function extendRangeInternal(opts,getValue){let range=opts.range;let size=Math.ceil(opts.max);for(let i=Math.floor(opts.min);i<size;++i){let multiplier=Math.pow(10,i);let logValue=getValue(multiplier);if(isValueDifferenceLessThanDivisor({newValue:logValue,multiplier:multiplier,range:range})){continue;}
if(!range.includes(logValue)&&isInsideRange(logValue,opts)){range.push(logValue);}}}
return Object.freeze({initSourceData:function(settings){if(!settings){console.warn('Can not initialize LogarithmicTickValuesRepository');return;}
m_sourceArray=m_deepCopyCreator.createDeepCopy(settings.source);},range:function(){let rangeDetector=new PMI_REPORT_MODULE.ArrayRangeDetector(m_sourceArray);sortRange(m_sourceArray);m_minimum=Number(rangeDetector.min());m_maximum=Number(rangeDetector.max());m_fromMaxToMin=m_maximum-m_minimum;m_rawValues=[];let opts={max:m_maximum,min:m_minimum,range:[],};initRawValuesArrayAndInitRangeArrayWithRoundedLog10Values(opts);extendRange(opts);sortRange(opts.range);return{max:Math.max(m_maximum,opts.max),min:Math.min(m_minimum,opts.min),range:opts.range};},rawValues:function(){return m_rawValues;}})};
//# sourceURL=LogarithmicTickValuesRepository.js