PMI_REPORT_MODULE.scriptLoader.include('pivotTab/models/PeptideModificationRepository.js');PMI_REPORT_MODULE.scriptLoader.include('pivotTab/models/PeptideModificationSettingsKeys.js');PMI_REPORT_MODULE.scriptLoader.include('models/peptideModifications/IsGlycationTypeRowStrategy.js');PMI_REPORT_MODULE.PeptideModificationFilters=function(){'use strict';let m_peptideModificationSettingsKeys=new PMI_REPORT_MODULE.PeptideModificationSettingsKeys();let m_cachedWildtypeCorrespondingToModifiedPeptides={};const m_modificationNameColumnKey=m_peptideModificationSettingsKeys.modificationNameColumnKey();const m_modificationsIdListColumnName="_mod\nids";const m_sequenceUnformatted="Sequence\n(unformatted)";const m_modCategoryColumnName="ModCategory";const m_gly='gly';let m_peptideModificationRepository=new PMI_REPORT_MODULE.PeptideModificationRepository();const m_modNamesSeparator=';';const m_mut='mut';let m_isGlycationTypeInternal=new PMI_REPORT_MODULE.IsGlycationTypeRowStrategy();let m_useFilteringByModifications=false;let m_allFiltersDisable=false;let m_peptideModifications=new Map();let m_sequencesSet=new Set();const m_deamidationModsKey=m_peptideModificationSettingsKeys.demidationMods();const m_oxidationModsKey=m_peptideModificationSettingsKeys.oxidationMods();const m_ammoniaLossKey=m_peptideModificationSettingsKeys.amoniaLossMods();const m_allPeptidesKey=m_peptideModificationSettingsKeys.allPeptidesMods();const m_disulfideCrossLinksKey=m_peptideModificationSettingsKeys.disulfidesCrossLinkMods();const m_glycationKey=m_peptideModificationSettingsKeys.glycationMods();const m_correspondingWildtypesKey=m_peptideModificationSettingsKeys.correspondingPeptidesMods();const m_wildtypePeptidesKey=m_peptideModificationSettingsKeys.wildtypePeptidesMods();const m_allModifiedPeptidesKey=m_peptideModificationSettingsKeys.allModifiedPeptidesMods();const m_sequenceVariantKey=m_peptideModificationSettingsKeys.sequenceVariantsMods();const m_glycosylationKey=m_peptideModificationSettingsKeys.glycosylationMods();const m_modsToSearchingSubstrings={[m_deamidationModsKey]:'deamidat',[m_oxidationModsKey]:'oxidation',[m_ammoniaLossKey]:['ammonia','loss'],[m_disulfideCrossLinksKey]:['{s-s-','{xlink-','disulfide','trisulfide','link'],[m_allPeptidesKey]:'',[m_glycationKey]:['hex']};function nameInclude(opts){let name=opts.modNames;let substring=opts.substrings;return name.toLowerCase().includes(substring);}
function nameStartsWith(opts){let name=opts.modNames;let substring=opts.substrings;return name.toLowerCase().startsWith(substring);}
function isTypeInternal(opts){const modNames=opts.modNames;const key=opts.key;let isShowed=opts.isShowed;let peptideModification=m_peptideModifications.get(key);if(!modNames){return false;}
return peptideModification.show()&&isShowed({modNames:modNames,substrings:m_modsToSearchingSubstrings[key]});}
function isDeamidationType(row){return isTypeInternal({modNames:row[m_modificationNameColumnKey],key:m_deamidationModsKey,isShowed:nameInclude});}
function isOxidationType(row){return isTypeInternal({modNames:row[m_modificationNameColumnKey],key:m_oxidationModsKey,isShowed:nameInclude});}
function isAmmoniaLossType(row){return isTypeInternal({modNames:row[m_modificationNameColumnKey],key:m_ammoniaLossKey,isShowed:function(opts){let keys=opts.substrings;let value=opts.modNames;for(let i=0;i<keys.length;++i){const key=keys[i];if(!nameInclude({modNames:value,substrings:key})){return false;}}
return true;}});}
function isDisulfideCrossLinkType(row){let values=row[m_modificationNameColumnKey];if(!values){return false;}
let modNames=values.split(m_modNamesSeparator);for(let i=0,size=modNames.length;i<size;++i){if(isTypeInternal({modNames:modNames[i].trim(),key:m_disulfideCrossLinksKey,isShowed:function(opts){let keys=opts.substrings;let value=opts.modNames;for(let i=0;i<keys.length;++i){const key=keys[i];if(nameStartsWith({modNames:value,substrings:key})){return true;}}
return false;}})){return true;}}
return false;}
function isGlycationType(row){let values=row[m_modificationNameColumnKey];if(!values){return false;}
let modNames=values.split(m_modNamesSeparator);for(let i=0,size=modNames.length;i<size;++i){if(isTypeInternal({modNames:modNames[i].trim(),key:m_glycationKey,isShowed:m_isGlycationTypeInternal.isGlycation})){return true;}}
return false;}
function isCorrespondingWildtypeRow(row){let modificationsIdList=row[m_modificationsIdListColumnName];let isModificationsIdListEmpty=!modificationsIdList;let showed=m_peptideModifications.get(m_correspondingWildtypesKey).show()||m_peptideModifications.get(m_allPeptidesKey).show()||m_peptideModifications.get(m_wildtypePeptidesKey).show();return isModificationsIdListEmpty&&showed;}
function isModifiedPeptidesType(row){let modificationsIdList=row[m_modificationsIdListColumnName];let showed=m_peptideModifications.get(m_allModifiedPeptidesKey).show();return showed&&(modificationsIdList===0||modificationsIdList);}
function isWildTypePeptideType(row){let modificationsIdList=row[m_modificationsIdListColumnName];let showed=m_peptideModifications.get(m_wildtypePeptidesKey).show();if(modificationsIdList===0||!showed){return false;}
return!modificationsIdList;}
function checkModCategory(value){if(Array.isArray(value)){return value;}
return value.split(',');}
function isSequenceVariantType(row){let showed=m_peptideModifications.get(m_sequenceVariantKey).show();if(!showed){return false;}
let modCategory=row[m_modCategoryColumnName];if(!modCategory){return false;}
modCategory=checkModCategory(modCategory);return modCategory&&modCategory.findIndex&&modCategory.findIndex(category=>category.toLowerCase().trim()===m_mut)!==-1;}
function isGlycosylationType(row){const showed=m_peptideModifications.get(m_glycosylationKey).show();if(!showed){return false;}
let modCategory=row[m_modCategoryColumnName];if(!modCategory){return false;}
modCategory=checkModCategory(modCategory);return modCategory&&modCategory.findIndex&&modCategory.findIndex(category=>category.toLowerCase().endsWith(m_gly))!==-1;}
function isFilteringDisable(){return!m_useFilteringByModifications||m_peptideModifications.get(m_allPeptidesKey).show()||m_allFiltersDisable;}
function isFiltered(row){if(isFilteringDisable()){return false;}
if(isWildTypePeptideType(row)){return false;}
if(isCorrespondingWildtypeRow(row)){return false;}
const isFiltered=!(isDeamidationType(row)||isOxidationType(row)||isAmmoniaLossType(row)||isDisulfideCrossLinkType(row)||isGlycationType(row)||isModifiedPeptidesType(row)||isGlycosylationType(row)||isSequenceVariantType(row));if(!isFiltered){let sequenceUnformatted=row[m_sequenceUnformatted];if(!m_sequencesSet.has(sequenceUnformatted)){m_sequencesSet.add(sequenceUnformatted);}}
return isFiltered;}
function isInsideCachedWildtypeCorrespondingToModifiedPeptides(sequence){if(!m_cachedWildtypeCorrespondingToModifiedPeptides){return false;}
const keysToCheck=[m_sequenceVariantKey,m_allModifiedPeptidesKey,m_glycosylationKey,m_glycationKey,m_disulfideCrossLinksKey,m_ammoniaLossKey,m_oxidationModsKey,m_deamidationModsKey];for(let i=0,size=keysToCheck.length;i<size;++i){const key=keysToCheck[i];const container=m_cachedWildtypeCorrespondingToModifiedPeptides[key];if(container&&m_peptideModifications.get(key).show()&&container.includes(sequence)){return true;}}
return false;}
function filterNotCorresponding(opts){let flatTable=opts.flatTable;if(!m_peptideModifications.get(m_correspondingWildtypesKey).show()||isFilteringDisable()||m_peptideModifications.get(m_wildtypePeptidesKey).show()){return flatTable;}
let returned=[];for(let i=0,size=flatTable.length;i<size;++i){let row=flatTable[i];let modificationsIdList=row[m_modificationsIdListColumnName];let isModificationsIdListEmpty=!modificationsIdList;const sequence=row[m_sequenceUnformatted];const isInsideCorrespondingCache=isInsideCachedWildtypeCorrespondingToModifiedPeptides(sequence);if(!isModificationsIdListEmpty||(isModificationsIdListEmpty&&(m_sequencesSet.has(sequence)||isInsideCorrespondingCache))){returned.push(row);}}
return returned;}
return Object.freeze({filter:function(opts){let returned=[];let flatTable=opts.flatTable;for(let i=0,size=flatTable.length;i<size;++i){let row=flatTable[i];if(!isFiltered(row)){returned.push(row);}}
return filterNotCorresponding({flatTable:returned});},beforeFilter:function(opts){m_useFilteringByModifications=m_peptideModificationRepository.useFilteringByModifications();m_allFiltersDisable=m_peptideModificationRepository.allPeptideModificationNotShowed();m_cachedWildtypeCorrespondingToModifiedPeptides=opts?opts.cachedWildtypeCorrespondingToModifiedPeptides:{};let mods=Object.keys(m_modsToSearchingSubstrings);for(let i=0,size=mods.length;i<size;++i){const key=mods[i];let peptideModification=m_peptideModificationRepository.getModificationByMods(key);m_peptideModifications.set(key,peptideModification);}
m_peptideModifications.set(m_correspondingWildtypesKey,m_peptideModificationRepository.getModificationByMods(m_correspondingWildtypesKey));m_peptideModifications.set(m_wildtypePeptidesKey,m_peptideModificationRepository.getModificationByMods(m_wildtypePeptidesKey));m_peptideModifications.set(m_allModifiedPeptidesKey,m_peptideModificationRepository.getModificationByMods(m_allModifiedPeptidesKey));m_peptideModifications.set(m_glycosylationKey,m_peptideModificationRepository.getModificationByMods(m_glycosylationKey));m_peptideModifications.set(m_sequenceVariantKey,m_peptideModificationRepository.getModificationByMods(m_sequenceVariantKey));m_sequencesSet=new Set();},initDependencies:function(opts){let mediator=opts.mediator;if(typeof mediator==='undefined'){return;}
m_peptideModificationRepository.initDependencies(opts.model);mediator.subscribe(mediator.EVENT_TYPE.AFTER_CREATED_PIVOT_DATA,function(){m_useFilteringByModifications=false;m_peptideModifications=new Map();m_allFiltersDisable=false;});}})};
//# sourceURL=PeptideModificationFilters.js