PMI_REPORT_MODULE.scriptLoader.include("pivotTab/models/protein3D/InitialProtein3DChainConfigurationCreator.js");PMI_REPORT_MODULE.scriptLoader.include("pivotTab/core/Protein3DAtomResidueRangeValue.js");PMI_REPORT_MODULE.scriptLoader.include("core/HtmlElementsIdentifierNames.js");var protein3dViewportManager=(function(){'use strict';var m_stageViewport=null;const m_viewportId='viewport';var m_proteinSettingsManager=null;let m_colorValueToColorMap=null;var m_implementation=null;var resetViewportSettings=function(){protein3DColorBarsManager.removeColorBars();m_colorValueToColorMap.resetColorSpectrum();if(m_stageViewport){m_stageViewport.setSpin(false);}};var initStageViewport=function(){try{if(m_stageViewport===null){m_stageViewport=new NGL.Stage(m_viewportId);if(!m_stageViewport){return false;}
m_stageViewport.setParameters({backgroundColor:"white"});}}catch(error){console.log(error);return false;}
return true;};var stageViewport=function(){initStageViewport();return m_stageViewport;};return{stageInitializedCallback:function(options,proteinSettingsManager){if(!m_stageViewport){crossCuttingLayer.embeddedJavaScriptLogic.emitSigFrameContentLoaded();return;}
m_stageViewport.autoView();try{m_implementation.stageInitializedCallback(m_viewportId,proteinSettingsManager);}catch(error){console.error('Error inside stageInitializedCallback, details: ',error);crossCuttingLayer.embeddedJavaScriptLogic.emitSigFrameContentLoaded();}
setTimeout(function(){m_implementation.onViewportCreated();crossCuttingLayer.embeddedJavaScriptLogic.emitSigFrameContentLoaded();m_implementation.restoreGeometry();},100);},initDependencies:function(dependencies){m_colorValueToColorMap=dependencies.colorValueToColorMap;if(!m_implementation){console.error('Implementation is not valid');return;}
m_implementation.initDependencies(dependencies);},initStageViewport:initStageViewport,loadElements:function(){if(!initStageViewport()){crossCuttingLayer.embeddedJavaScriptLogic.emitSigFrameContentLoaded();return;}
m_stageViewport.removeAllComponents();var resultOfFunctionCall=false;try{resultOfFunctionCall=m_implementation.loadElements(m_proteinSettingsManager,resetViewportSettings,m_stageViewport);}catch(error){PMI_REPORT_MODULE.alert('Error during parse protein3d content: \n'+error.message);console.warn(error);crossCuttingLayer.embeddedJavaScriptLogic.emitSigFrameContentLoaded();}
return resultOfFunctionCall;},loadDataFromDocument:function(dataName,settings,callback){settings.ext="pdb";crossCuttingLayer.webkitBridgeDao.getProteinDatabaseContent(dataName).then(function(pdbData){if(pdbData.length===0){console.log('Data content named '+dataName+' is empty or does not exist.');}
var stringBlob=new Blob([pdbData],{type:'text/plain'});return stageViewport().loadFile(stringBlob,settings).then(callback);});return true;},stageViewport:stageViewport,defaultProteinViewerContentFunction:function(){return crossCuttingLayer.webkitBridgeDao.getFileContentCore(crossCuttingLayer.javaScriptHelper.protein3dScriptDefaultFile());},handleResize:function(){if(!m_stageViewport){return;}
m_stageViewport.handleResize();},clearViewport:function(){if(!m_implementation){crossCuttingLayer.javaScriptHelper.outputMessageToStdout('3DViewportManagerIssue:','Viewport implementation is null');return;}
protein3DColorBarsManager.removeColorBars();m_implementation.clearViewport(m_stageViewport,m_viewportId);},viewportId:function(){return m_viewportId;},setProteinSettingsManager:function(manager){m_proteinSettingsManager=manager;},setViewportImplementation:function(implementation){m_implementation=implementation;},viewportDataChains:function(){return m_implementation.chains();},autoDeltaRange:function(chainName){return m_implementation.autoDeltaRange(chainName);},cachedColors:function(){return m_implementation.cachedColors();},cachedColorForValue:function(){return m_implementation.cachedColorForValue();},beforeRenderViewport:function(options,proteinSettingsManager){return m_implementation.beforeRenderViewport(options,proteinSettingsManager);},autoView:function(){m_stageViewport.autoView();}}})();var viewportManagerImplFactory=(function(){'use strict';const m_TabType={PIVOT_TAB:0,PROTEIN_TAB:1};Object.freeze(m_TabType);let m_colorValueToColorMap=null;let m_sorter=null;var pivotTabImplementation=(function(){var m_chains=[];let m_chainNameToResnoRangeMap={};let m_protein3DBasicSettingsCreator=PMI_REPORT_MODULE.InitialProtein3DChainConfigurationCreator?new PMI_REPORT_MODULE.InitialProtein3DChainConfigurationCreator():null;var beforeRenderViewport=function(options,proteinSettingsManager){m_chains=[];m_chainNameToResnoRangeMap={};options.structure.eachAtom(function(atom){let chainName=atom.chainname;let residueNumber=atom.resno;if(m_chains.indexOf(chainName)===-1){m_chains.push(chainName);}
if(!m_chainNameToResnoRangeMap[chainName]){m_chainNameToResnoRangeMap[chainName]=[];}
if(m_chainNameToResnoRangeMap[chainName].indexOf(residueNumber)===-1){m_chainNameToResnoRangeMap[chainName].push(residueNumber);}});m_chains.sort(m_sorter?m_sorter.naturalSort:null);m_protein3DBasicSettingsCreator.init(proteinSettingsManager);let chainNameToChainMap=proteinSettingsManager.chainNameToChainMap(autoDeltaRange);proteinSettingsManager.initColorRanges(m_chains);const colorNumbersCreator=new Protein3DColorNumberCreator();colorNumbersCreator.createColorNumberLabels(options,proteinSettingsManager,chainNameToChainMap);createColorScheme.cachedColors={};createColorScheme.cachedColorForValue={};return chainNameToChainMap;};var createColorScheme=function(chainNameToChainMap,proteinSettingsManager){return NGL.ColormakerRegistry.addScheme(function(){this.atomColor=function(atom){const chainName=atom.chainname;if(!chainNameToChainMap.hasOwnProperty(chainName)){return m_colorValueToColorMap.basicDefaultColorRgb();}
const chainValues=chainNameToChainMap[chainName];let value=m_colorValueToColorMap.basicDefaultColorRgb();for(let i=(chainValues.length-1);i>=0;--i){let chain=chainValues[i];const key=chain.uniqueKey();const valueDetector=new Protein3DAtomResidueRangeValue(atom,chain);const residueNumber=valueDetector.residueValue();let indexRangeDetector=new Protein3DIndexRangeDetector();if(!createColorScheme.cachedColors[key]){createColorScheme.cachedColors[key]={};createColorScheme.cachedColors[key].rawColors=tabHelperObject.protein3DColors.colorValues(chain.chainValues());createColorScheme.cachedColors[key].defaultColor=undefined;createColorScheme.cachedColorForValue[key]={};}
if(createColorScheme.cachedColors[key].defaultColor===undefined){createColorScheme.cachedColors[key].defaultColor=m_colorValueToColorMap.defaultColor(key);createColorScheme.cachedColorForValue[key].defaultColor=createColorScheme.cachedColors[key].defaultColor;}
value=createColorScheme.cachedColors[key].defaultColor;indexRangeDetector.initColorValues(createColorScheme.cachedColors[key].rawColors);if(!createColorScheme.cachedColors[key].filteredColors){createColorScheme.cachedColors[key].filteredColors=indexRangeDetector.filterColorValues();}
let colorValues=createColorScheme.cachedColors[key].filteredColors;if(!colorValues||!colorValues.hasOwnProperty(residueNumber)){continue;}
const colorValue=colorValues?colorValues[residueNumber]:undefined;const colorRgb=m_colorValueToColorMap.rgbColorForValue(key,colorValue);createColorScheme.cachedColorForValue[key][residueNumber]=colorRgb;value=colorRgb;break;}
return value;};});};const autoDeltaRange=function(chainName){let residueRange=m_chainNameToResnoRangeMap[chainName];let customValues=Object.keys(residueRange);return residueRange[customValues[0]];};const getLoadElementsInternalStrategy=function(){if(PMI_REPORT_MODULE.reportTypeDetector.isWebReportApplication()){return function(proteinSettingsManager,callback){const keys=new PMI_REPORT_MODULE.WebReportConfigurationKeys();let settings={defaultRepresentation:false};settings.ext="pdb";let pdbContentDiv=document.getElementById(keys.protein3DFileContentContainerId());if(!pdbContentDiv){console.error('PDB file content is empty!');return;}
let decompressor=new PMI_REPORT_MODULE.ReportModuleStringDecompressor();let pdbContent=decompressor.decompress(pdbContentDiv.textContent);let stringBlob=new Blob([pdbContent],{type:'text/plain'});return protein3dViewportManager.stageViewport().loadFile(stringBlob,settings).then(callback);}}else{return function(proteinSettingsManager,callback){const pdbData=proteinSettingsManager.pdbData();if(pdbData.dataType===pdbData.fileTypeKey){protein3dViewportManager.stageViewport().loadFile(pdbData.absolutePath,{defaultRepresentation:false}).then(callback);}else if(pdbData.dataType===pdbData.docTypeKey){protein3dViewportManager.loadDataFromDocument(pdbData.absolutePath,{defaultRepresentation:false},callback);}else{console.log('Unsupported data!');}}}};return{loadElementsInternal:function(proteinSettingsManager){let callback=function(options){let chainNameToChainMap=beforeRenderViewport(options,proteinSettingsManager);options.addRepresentation("cartoon",{colorScheme:(function(chainNameToChainMap,proteinSettingsManager){return createColorScheme(chainNameToChainMap,proteinSettingsManager);})(chainNameToChainMap,proteinSettingsManager)});protein3dViewportManager.stageInitializedCallback(options,proteinSettingsManager);PMI_REPORT_MODULE.protein3DDirector.updateUi(PMI_REPORT_MODULE.protein3DDirector.UPDATE_UI_OPTIONS.CHECK_VISIBILITY);};getLoadElementsInternalStrategy()(proteinSettingsManager,callback);},chains:function(){return m_chains;},autoDeltaRange:autoDeltaRange,cachedColors:function(){return createColorScheme.cachedColors;},cachedColorForValue:function(){return createColorScheme.cachedColorForValue;},beforeRenderViewport:beforeRenderViewport}})();var pivotTabPrototype={clearViewport:function(stageViewport,viewportId){if(!stageViewport){return;}
if(stageViewport){stageViewport.setSpin(false);}
stageViewport.removeAllComponents();},loadElements:function(proteinSettingsManager,resetViewportSettings){resetViewportSettings();pivotTabImplementation.loadElementsInternal(proteinSettingsManager);protein3dViewportManager.stageViewport().viewerControls.orient([-44.74,-29.49,-149.07,0,0.363,-153.79,30.32,0,-153.09,8.37,44.29,0,-12.116268157958984,7.966012954711914,-43.65300273895264,1]);return true;},chains:function(){return pivotTabImplementation.chains();},stageInitializedCallback:function(viewportId,proteinSettingsManager){let keys=new PMI_REPORT_MODULE.HtmlElementsIdentifierNames();protein3DColorBarsManager.createColorBars(keys.nonPlotsTabRenderContentContainerId(),viewportId,proteinSettingsManager);},onViewportCreated:function(){PMI_REPORT_MODULE.pivotTabEventAggregator.publish(PMI_REPORT_MODULE.pivotTabEventAggregator.EVENT_TYPE.TAB_CONTENT_LOADED);},autoDeltaRange:function(chainName){return pivotTabImplementation.autoDeltaRange(chainName);},cachedColors:function(){return pivotTabImplementation.cachedColors();},cachedColorForValue:function(){return pivotTabImplementation.cachedColorForValue();},restoreGeometry:function(){PMI_REPORT_MODULE.pivotTabEventAggregator.publish(PMI_REPORT_MODULE.pivotTabEventAggregator.EVENT_TYPE.RESTORE_TAB_CONTENT_GEOMETRY);},beforeRenderViewport:function(options,proteinSettingsManager){return pivotTabImplementation.beforeRenderViewport(options,proteinSettingsManager);},initDependencies:function(dependencies){m_colorValueToColorMap=dependencies.colorValueToColorMap;m_sorter=dependencies.sorter;}};var protein3DTabPrototype={clearViewport:function(stageViewport){if(!stageViewport){return;}
stageViewport.removeAllComponents();stageViewport.dispose();stageViewport=null;},loadElements:function(proteinSettingsManager,resetViewportSettings,stageViewport){var functionBody=proteinSettingsManager.proteinLoaderContent();if(functionBody.length===0){proteinSettingsManager.initDefaultSettings();functionBody=proteinSettingsManager.proteinLoaderContent();}
resetViewportSettings();var script=functionBody.parseFunction();if(!script){return false;}
return script();},chains:function(){return[];},stageInitializedCallback:function(viewportId,proteinSettingsManager){let keys=new PMI_REPORT_MODULE.HtmlElementsIdentifierNames();protein3DColorBarsManager.createColorBars(keys.nonPlotsTabRenderContentContainerId(),viewportId,proteinSettingsManager);},restoreGeometry:function(){},initDependencies:function(dependencies){m_colorValueToColorMap=dependencies.colorValueToColorMap;},onViewportCreated:function(){}};return{create:function(tabType,options){var proto={};switch(tabType)
{case m_TabType.PIVOT_TAB:{PMI_REPORT_MODULE.scriptLoader.include("pivotTab/core/Protein3DIndexRangeDetector.js");proto=pivotTabPrototype;break;}
case m_TabType.PROTEIN_TAB:proto=protein3DTabPrototype;break;default:console.log('Unsupported tab type!');break;}
return Object.create(proto,options);},TAB_TYPE:m_TabType}})();
//# sourceURL=protein3dViewportManager.js