var protein3DColorBarsManager=(function(){'use strict';const m_rangeColor='rgb(47, 47, 47)';const m_fontPxSize=11;const m_fontStyle=m_fontPxSize+'px sans-serif';const m_tickHeight=10;const m_chainNameTextHeight=m_fontPxSize;const m_rangeLineHeight=1;const m_marginBetweenRangeLineAndColorBar=1;const m_marginBetweenTextAndTick=1;const m_tickWidth=1;const m_colorPixelWidth=4;const m_colorBarColorAreaHeight=9;const m_colorBarRangeAreaHeight=m_fontPxSize+m_tickHeight+m_rangeLineHeight+m_marginBetweenRangeLineAndColorBar+m_marginBetweenTextAndTick+m_chainNameTextHeight;const m_colorBarHeight=m_colorBarColorAreaHeight+m_colorBarRangeAreaHeight;const m_textAlign='center';const m_colorBarsContainerId='colorBarsContainer';const m_numberOfColorBarColors=62;var m_createColorBarsStrategy=null;let m_colorValueToColorMap=null;var initContextWithCustomSettings=function(ctx){ctx.textAlign=m_textAlign;ctx.font=m_fontStyle;};var detectMarginSize=function(ctx,text){initContextWithCustomSettings(ctx);var metrics=ctx.measureText(text);const centerText=ctx.textAlign==='center';var width=centerText?(metrics.width/2):metrics.width;return Math.ceil(width);};var createTickMarks=function(ctx,margin,chainName){const rangeValues=createRangeValues(chainName);const lineYPos=m_colorBarRangeAreaHeight-m_marginBetweenRangeLineAndColorBar-m_rangeLineHeight;const contentWidth=m_colorPixelWidth*m_numberOfColorBarColors;const rangeWidth=contentWidth-m_tickWidth;const xPosition=[0,(rangeWidth/4),(rangeWidth/2),0.75*rangeWidth,rangeWidth];var rangeValueIndex=0;for(var i=0;i<xPosition.length;++i){var x=xPosition[i];ctx.fillStyle=m_rangeColor;const bigTick=(i%2)==0;var tickUsedHeight=bigTick?m_tickHeight:m_tickHeight/2;ctx.fillRect(margin+x,lineYPos-tickUsedHeight,m_tickWidth,tickUsedHeight);if(!bigTick){continue;}
initContextWithCustomSettings(ctx);ctx.fillText(rangeValues[rangeValueIndex],margin+x,m_chainNameTextHeight+m_fontPxSize-m_marginBetweenTextAndTick);++rangeValueIndex;}};function createColorGradient(ctx,margin,chainName){m_createColorBarsStrategy.createColorGradient({ctx:ctx,margin:margin,chainName:chainName,colorBarRangeAreaHeight:m_colorBarRangeAreaHeight,colorPixelWidth:m_colorPixelWidth,colorBarColorAreaHeight:m_colorBarColorAreaHeight,numberOfColors:m_numberOfColorBarColors,colorValueToColorMap:m_colorValueToColorMap})}
var createRangeLine=function(ctx,margin){const contentWidth=m_colorPixelWidth*m_numberOfColorBarColors;const lineYPos=m_colorBarRangeAreaHeight-m_marginBetweenRangeLineAndColorBar-m_rangeLineHeight;ctx.fillStyle=m_rangeColor;ctx.fillRect(margin,lineYPos,contentWidth,m_rangeLineHeight);};const roundValue=function(value){return m_createColorBarsStrategy.roundValue(value);};var createRangeValues=function(chainName){const min=m_colorValueToColorMap.colorRangeMinimum(chainName);const max=m_colorValueToColorMap.colorRangeMaximum(chainName);return[roundValue((min)),roundValue(((min+max)/2)),roundValue((max))];};var createColorBar=function(chainKey,colorBarsContainer){var colorBar=document.createElement('canvas');let chainUniqueKey=chainKey.uniqueKey?chainKey.uniqueKey:chainKey;var ctx=colorBar.getContext('2d');const colorTextRanges=createRangeValues(chainUniqueKey);const leftMargin=detectMarginSize(ctx,colorTextRanges[0]);const rightMargin=detectMarginSize(ctx,colorTextRanges[(colorTextRanges.length-1)]);colorBar.height=m_colorBarHeight;colorBar.width=(m_colorPixelWidth*m_numberOfColorBarColors)+leftMargin+rightMargin;colorBar.style.setProperty("height",colorBar.height+'px',"important");colorBar.style.setProperty("width",colorBar.width+'px',"important");colorBar.style.marginLeft='10px';createChainNameForColorBar(ctx,leftMargin,chainKey.displayUniqueKey?chainKey.displayUniqueKey:chainKey);createColorGradient(ctx,leftMargin,chainUniqueKey);createRangeLine(ctx,leftMargin,chainUniqueKey);createTickMarks(ctx,leftMargin,chainUniqueKey);colorBar.title=chainUniqueKey;colorBarsContainer.appendChild(colorBar);};var createChainNameForColorBar=function(ctx,leftMargin,chainName){if(chainName===m_colorValueToColorMap.defaultColorRangeAndSpectrumKey()){return;}
ctx.font=m_fontStyle;ctx.fillText(chainName,leftMargin,m_chainNameTextHeight);};return{removeColorBars:function(){m_createColorBarsStrategy.removeColorBars(m_colorBarsContainerId);},setCreateColorBarsStrategy:function(strategy){m_createColorBarsStrategy=strategy;},colorBarsContainerId:function(){return m_colorBarsContainerId;},initDependencies:function(dependencies){m_colorValueToColorMap=dependencies.colorValueToColorMap;},createColorBar:createColorBar,createColorBars:function(parentId,previousElementId,proteinSettingsManager){if(!m_colorValueToColorMap.isCustomRangeUsed()||!m_createColorBarsStrategy){console.warn('Create color bars strategy is empty');return;}
let colorBarsContainer=m_createColorBarsStrategy.createColorsBarContainer(parentId,previousElementId,m_colorBarsContainerId);if(!colorBarsContainer){return;}
var chainNames=m_createColorBarsStrategy.chainNames(proteinSettingsManager,m_colorValueToColorMap);for(let i=0;i<chainNames.length;++i){let chainName=chainNames[i];createColorBar(chainName,colorBarsContainer);}}}})();
//# sourceURL=protein3DColorBarsManager.js