PMI_REPORT_MODULE.PostMessageSecurityValidator=(function(){'use strict';const ALLOWED_ORIGINS=new Set();const CONFIG={DEBUG:false,DEV_PORTS:[3000,4200,5000,8000,8080,8443,9000],ALLOW_DEV_PORTS:true,STRICT_MODE:false};(function initAllowedOrigins(){ALLOWED_ORIGINS.add(window.location.origin);if(CONFIG.DEBUG){console.log('[PostMessageSecurity] Initialized with origin:',window.location.origin);}
if(!CONFIG.STRICT_MODE&&isDevelopmentEnvironment()){addDevelopmentOrigins();}
tryAddParentOrigin();})();function isDevelopmentEnvironment(){const hostname=window.location.hostname;return hostname==='localhost'||hostname==='127.0.0.1'||hostname.endsWith('.local')||hostname.endsWith('.localhost');}
function addDevelopmentOrigins(){ALLOWED_ORIGINS.add('http://localhost');ALLOWED_ORIGINS.add('https://localhost');ALLOWED_ORIGINS.add('http://127.0.0.1');ALLOWED_ORIGINS.add('https://127.0.0.1');if(CONFIG.ALLOW_DEV_PORTS){CONFIG.DEV_PORTS.forEach(port=>{ALLOWED_ORIGINS.add(`http://localhost:${port}`);ALLOWED_ORIGINS.add(`https://localhost:${port}`);ALLOWED_ORIGINS.add(`http://127.0.0.1:${port}`);ALLOWED_ORIGINS.add(`https://127.0.0.1:${port}`);});}
if(CONFIG.DEBUG){console.log('[PostMessageSecurity] Added development origins');}}
function tryAddParentOrigin(){if(window.parent!==window&&window.parent.location){try{const parentOrigin=window.parent.location.origin;if(parentOrigin){ALLOWED_ORIGINS.add(parentOrigin);if(CONFIG.DEBUG){console.log('[PostMessageSecurity] Added parent origin:',parentOrigin);}}}catch(e){if(CONFIG.DEBUG){console.debug('[PostMessageSecurity] Parent frame is cross-origin, will validate via event');}}}}
function isValidOrigin(event){if(!event||!event.origin){console.warn('[PostMessageSecurity] Invalid event or missing origin');return false;}
if(ALLOWED_ORIGINS.has(event.origin)){if(CONFIG.DEBUG){console.log('[PostMessageSecurity]     Accepted origin:',event.origin);}
return true;}
if(!CONFIG.STRICT_MODE&&CONFIG.ALLOW_DEV_PORTS&&isDevelopmentEnvironment()){if(isSameHostDifferentPort(event.origin)){ALLOWED_ORIGINS.add(event.origin);if(CONFIG.DEBUG){console.log('[PostMessageSecurity]     Accepted same-host dev origin:',event.origin);}
return true;}}
console.warn('[PostMessageSecurity]     Rejected unauthorized origin:',event.origin);return false;}
function isSameHostDifferentPort(eventOrigin){try{const eventURL=new URL(eventOrigin);const currentURL=new URL(window.location.origin);return eventURL.hostname===currentURL.hostname&&eventURL.protocol===currentURL.protocol;}catch(e){console.error('[PostMessageSecurity] Error parsing origin URL:',e);return false;}}
function isValidMessageData(data){if(data===null||data===undefined){return true;}
return true;}
function isValidMessage(event){if(!isValidOrigin(event)){return false;}
if(!isValidMessageData(event.data)){console.warn('[PostMessageSecurity] Invalid message data structure');return false;}
return true;}
function getTargetOrigin(targetWindow){if(targetWindow===window){return window.location.origin;}
if(targetWindow===window.parent){try{return window.parent.location.origin;}catch(e){return window.location.origin;}}
return window.location.origin;}
function safePostMessage(targetWindow,data,origin){if(!targetWindow||!targetWindow.postMessage){console.error('[PostMessageSecurity] Invalid target window');return false;}
const targetOrigin=origin||getTargetOrigin(targetWindow);if(CONFIG.DEBUG){console.log('[PostMessageSecurity] Sending message to:',targetOrigin);}
try{targetWindow.postMessage(data,targetOrigin);return true;}catch(e){console.error('[PostMessageSecurity] Error sending message:',e);return false;}}
function addAllowedOrigin(origin){try{new URL(origin);ALLOWED_ORIGINS.add(origin);if(CONFIG.DEBUG){console.log('[PostMessageSecurity] Added custom origin:',origin);}
return true;}catch(e){console.error('[PostMessageSecurity] Invalid origin format:',origin);return false;}}
function configure(options){if(options.DEBUG!==undefined){CONFIG.DEBUG=Boolean(options.DEBUG);}
if(options.STRICT_MODE!==undefined){CONFIG.STRICT_MODE=Boolean(options.STRICT_MODE);}
if(options.ALLOW_DEV_PORTS!==undefined){CONFIG.ALLOW_DEV_PORTS=Boolean(options.ALLOW_DEV_PORTS);}
if(Array.isArray(options.DEV_PORTS)){CONFIG.DEV_PORTS=options.DEV_PORTS;}}
return Object.freeze({isValidMessage:isValidMessage,isValidOrigin:isValidOrigin,isValidMessageData:isValidMessageData,safePostMessage:safePostMessage,getTargetOrigin:getTargetOrigin,configure:configure,addAllowedOrigin:addAllowedOrigin,getAllowedOrigins:function(){return Array.from(ALLOWED_ORIGINS);},getConfig:function(){return Object.assign({},CONFIG);},VERSION:'1.0.0'});})();
//# sourceURL=PostMessageSecurityValidator.js