// include PMISampleFileNameParser first

var PMIExpandSampleDigestion = {

    expand: function(samples, row, force) {
        if (!samples) {
            console.warn('Samples object is invalid')
            return false
        }

        var fileNameColumnIndex = -1
        var digestionColumnIndex = -1

        var fileNameColumnName = 'SamplePath'
        var digestionColumnName = 'Digestion'

        // add missing columns if necessary
        for (var i = 0; i < samples.columnCount; i++) {
            if (samples.columnName(i) === fileNameColumnName) {
                fileNameColumnIndex = i
            } else if (samples.columnName(i) === digestionColumnName) {
                digestionColumnIndex = i
            }
        }

        if (fileNameColumnIndex < 0) {
            console.warn('Cannot find a column with sample files')
            return false
        }

        if (digestionColumnIndex < 0) {
            if (!samples.addColumn(digestionColumnName)) {
                return false
            }

            digestionColumnIndex = samples.columnCount-1
        }

        // no need to update
        if (!force && samples.value(row, digestionColumnIndex)) {
            return true
        }

        var parsed = PMIVendorFileName.parse(samples.value(row, fileNameColumnIndex))

        if (!parsed || parsed.length === 0) {
            return false
        }

        // PTSON must contain index+1
        if (!samples.setValue(row, digestionColumnIndex, parsed.enzymeIndex+1)) {
            return false
        }

        return true
    }
}
