PMI_REPORT_MODULE.scriptLoader.include("core/ValuePrecisionCalculator.js");PMI_REPORT_MODULE.scriptLoader.include("core/ValueConverter.js");PMI_REPORT_MODULE.scriptLoader.include("vendor/stylesheetSpinBox.css");function SpinBox(container,options){if(typeof container=='string'){this.containerId=container;container=document.getElementById(container);}else if(container){this.containerId=container.id;}
this._setValueDecorators=[];this.options=(options?options:{});if(!('className'in this.options))this.options.className='spinBox';if(!('step'in this.options))this.options.step=1;if(!('decimals'in this.options))this.options.decimals=0;var inputs=container.getElementsByTagName('input');if(inputs.length==0){this.input=document.createElement('input');this.setValue('value'in this.options?this.options.value:0);container.appendChild(this.input);}else{this.input=inputs[0];this.setValue(this.options.value?this.options.value:this.input.value);}
var upButton=document.createElement('span');upButton.appendChild(document.createElement('span'));container.appendChild(upButton);var downButton=document.createElement('span');downButton.appendChild(document.createElement('span'));container.appendChild(downButton);container.className+=' '+this.options.className;upButton.className=this.options.className+'Up';downButton.className=this.options.className+'Down';this.addEventListener(this.input,'mousewheel',this.handleMouseWheel,[],true);this.addEventListener(this.input,'DOMMouseScroll',this.handleMouseWheel,[],true);this.addEventListener(this.input,'keydown',this.handleKeyDown,[],true);this.addEventListener(this.input,'keypress',this.handleKeyPress,[],true);this.addEventListener(this.input,'keyup',this.stop);this.addEventListener(upButton,'mousedown',this.start,[true]);this.addEventListener(upButton,'mouseup',this.stop);this.addEventListener(upButton,'mouseout',this.stop);this.addEventListener(downButton,'mousedown',this.start,[false]);this.addEventListener(downButton,'mouseup',this.stop);this.addEventListener(downButton,'mouseout',this.stop);this.valueConverter=new PMI_REPORT_MODULE.ValueConverter();var spinBox=this;this.input.onblur=function(){spinBox.setValue(this.value);}}
SpinBox.prototype.getValue=function(){return parseFloat(this.input.value);};SpinBox.prototype.parent=function(){return this.input.parentNode;};SpinBox.prototype.getContainerId=function(){return this.containerId;};SpinBox.prototype.setValue=function(value){if(this.isFrozen){return;}
if('minimum'in this.options)value=Math.max(this.options.minimum,value);if('maximum'in this.options)value=Math.min(this.options.maximum,value);for(let i=0,size=this._setValueDecorators.length;i<size;++i){let fun=this._setValueDecorators[i];if(!fun){continue;}
value=fun(value);}
var sign=(value<0?'-':'');value=Math.abs(value);let precisionCalculator=new ValuePrecisionCalculator();if(this.options.decimals>0&&precisionCalculator.calculate(value)>this.options.decimals&&this.valueConverter&&PMI_REPORT_MODULE.pivotTabSettingsRepository){this.valueConverter.initDependencies({database:PMI_REPORT_MODULE.pivotTabSettingsRepository});value=this.valueConverter.roundValueBasedOnTabSettingsConversion(value);}
const digitsAfterTheDecimal=precisionCalculator.calculate(value);const decimals=Math.max(this.options.decimals,digitsAfterTheDecimal);var multiplier=Math.pow(10,decimals);value=Math.round(value*multiplier);var integer=(value-value%multiplier)/multiplier;var fractional=''+value%multiplier;while(fractional.length<decimals){fractional='0'+fractional;}
this.input.value=sign+integer+(decimals>0?'.'+fractional:'');if('dispatchEvent'in this.input){try{var event=new Event('change',{bubbles:true,cancelable:true});}catch(e){var event=document.createEvent('Event');event.initEvent('change',true,true);}
this.input.dispatchEvent(event);}};SpinBox.prototype.addEventListener=function(node,event,listener,parameters,allowDefault){var thisObject=this;function boundListener(e){if(!e)e=window.event;listener.apply(thisObject,[e].concat(parameters));if(!allowDefault){if(e.preventDefault){e.preventDefault();}else{e.returnValue=false;}}}
if(node.addEventListener){node.addEventListener(event,boundListener,false);}else{node.attachEvent('on'+event,boundListener);}}
SpinBox.prototype.handleMouseWheel=function(e){if(document.activeElement==this.input){if(e.wheelDelta){this.start(e,e.wheelDelta>1);}else if(e.detail){this.start(e,e.detail<1);}
this.stop();if(e.preventDefault){e.preventDefault();}else{e.returnValue=false;}}};SpinBox.prototype.handleKeyDown=function(e){if(e.keyCode==38)this.start(e,true);if(e.keyCode==40)this.start(e,false);};SpinBox.prototype.handleKeyPress=function(e){var charCode=('charCode'in e?e.charCode:e.keyCode);if(charCode==0||e.altKey||e.ctrlKey||e.metaKey)return;if(charCode==45&&(!('minimum'in this.options)||this.options.minimum<0)){return;}
if(charCode==46&&this.options.decimals>0)return;if(charCode>=48&&charCode<=57)return;if(e.preventDefault){e.preventDefault();}else{e.returnValue=false;}};SpinBox.prototype.start=function(e,up){if(this.input.disabled||'timeout'in this)return;this.updateStep=(up?this.options.step:-this.options.step);this.timeoutDelay=500;this.update();};SpinBox.prototype.stop=function(){if('timeout'in this){window.clearTimeout(this.timeout);delete this.timeout;}};SpinBox.prototype.update=function(){var value=parseFloat(this.input.value);if(isNaN(value))value=0;this.setValue(parseFloat(value+this.updateStep).toFixed(this.options.decimals));this.timeoutDelay=Math.max(20,Math.floor(this.timeoutDelay*0.9));var thisObject=this;this.timeout=window.setTimeout(function(){thisObject.update();},this.timeoutDelay);};SpinBox.prototype.deselectValue=function(){this.setValue(this.options.value);};SpinBox.prototype.setFirstValue=function(){this.setValue(this.options.value);};
//# sourceURL=SpinBox.js