const defaultErrorChartOptions={color:'#000000',width:12,lineWidth:1,absoluteValues:false};const ErrorBarsPlugin={id:'chartJsPluginErrorBars',_getBarchartBaseCoords(chart){const coords=[];chart.data.datasets.forEach((d,i)=>{const bars=chart.getDatasetMeta(i).data;const values=d.data;coords.push(bars.map((b,j)=>{let barLabel='';if(!b._model.label){barLabel=chart.data.labels[j];}else{barLabel=b._model.label;}
return{label:barLabel,value:values[j],x:b._model.x,y:b._model.y,color:b._model.borderColor};}));});return coords;},_isHorizontal(chart){return chart.config.type==='horizontalBar';},_computeWidth(chart,horizontal,options){const width=options.width;let widthInPx=width;try{if(typeof width==='string'){if(width.match(/px/)){widthInPx=parseInt(width.replace(/px/,''),10);}else{const widthInPercent=Math.min(100,Math.abs(Number(width.replace(/%/,''))));const model=chart.getDatasetMeta(0).data[0]._model;if(chart.config.type==='line'){widthInPx=parseInt(model.controlPointPreviousX+model.controlPointNextX,10);}else if(horizontal){widthInPx=parseInt(model.height,10);}else if(!horizontal){widthInPx=parseInt(model.width,10);}
widthInPx=(widthInPercent/100)*widthInPx;}}}catch(e){console.error(e);}finally{if(Number.isNaN(widthInPx)){widthInPx=options.width;}}
return widthInPx;},_drawErrorBar(ctx,model,plus,minus,color,width,lineWidth,horizontal){ctx.save();ctx.lineWidth=lineWidth;ctx.strokeStyle=color;ctx.beginPath();if(horizontal){ctx.moveTo(minus,model.y-width/2);ctx.lineTo(minus,model.y+width/2);ctx.moveTo(minus,model.y);ctx.lineTo(plus,model.y);ctx.moveTo(plus,model.y-width/2);ctx.lineTo(plus,model.y+width/2);}else{ctx.moveTo(model.x-width/2,plus);ctx.lineTo(model.x+width/2,plus);ctx.moveTo(model.x,plus);ctx.lineTo(model.x,minus);ctx.moveTo(model.x-width/2,minus);ctx.lineTo(model.x+width/2,minus);}
ctx.stroke();ctx.restore();},afterDraw(chart,easingValue,options){chart.__renderedOnce=chart.__renderedOnce||easingValue===1;if(!chart.__renderedOnce){return;}
options=Object.assign({},defaultErrorChartOptions,options);const errorBarCoords=chart.data.datasets.map((d)=>d.errorBars);const barchartCoords=this._getBarchartBaseCoords(chart);if(!barchartCoords||!barchartCoords[0]||!barchartCoords[0][0]||!errorBarCoords){return;}
const horizontal=this._isHorizontal(chart);const vScale=horizontal?chart.scales['x-axis-0']:chart.scales['y-axis-0'];const errorBarWidth=this._computeWidth(chart,horizontal,options);const ctx=chart.ctx;ctx.save();barchartCoords.forEach((dataset,i)=>{dataset.forEach((bar)=>{let cur=errorBarCoords[i];if(!cur){return;}
let hasLabelProperty=cur.hasOwnProperty(bar.label);let errorBarData=null;if(hasLabelProperty){errorBarData=cur[bar.label];}else if(!hasLabelProperty&&bar.label&&bar.label.label&&cur.hasOwnProperty(bar.label.label)){errorBarData=cur[bar.label.label];}
if(errorBarData){const errorBarColor=options.color?options.color:bar.color;const plusValue=errorBarData.plus;const minusValue=errorBarData.minus;if(plusValue!==minusValue){const value=vScale.getRightValue(bar.value);const plus=vScale.getPixelForValue(value+plusValue);const minus=vScale.getPixelForValue(value+minusValue);this._drawErrorBar(ctx,bar,plus,minus,errorBarColor,errorBarWidth,options.lineWidth,horizontal);}}});});ctx.restore();}};Chart.pluginService.register(ErrorBarsPlugin);
//# sourceURL=ChartErrorPlots.js