PMI_REPORT_MODULE.scriptLoader.include("core/DecimalPlacesFormatter.js");PMI_REPORT_MODULE.scriptLoader.include("core/FontMetrics.js");PMI_REPORT_MODULE.scriptLoader.include('core/renderTypes.js');PMI_REPORT_MODULE.scriptLoader.include("pivotTab/models/PcaSettingsKeys.js");PMI_REPORT_MODULE.scriptLoader.include("pivotTab/models/PcaSettingsRepository.js");PMI_REPORT_MODULE.pcaRenderingEngine=(function(){'use strict';const m_keys=new PMI_REPORT_MODULE.PcaSettingsKeys();const m_margin={top:20,right:20,bottom:40,left:40};const m_attributeLineClassName='attributeLine';let m_textWidthCalculator=new PMI_REPORT_MODULE.FontMetrics();let m_database=null;let m_pcaRepository=null;let m_settingsKeys=null;var m_attributeNamesWithPCA;const m_attributeText='attributeData';const m_svgNamespace="http://www.w3.org/2000/svg";var m_color;var m_pcaObservationDotsManager=null;let m_decimalPlacesFormatter=new PMI_REPORT_MODULE.DecimalPlacesFormatter();let m_pivotTableTabColorsRepository=null;var m_svg;var m_xLinearRange;var m_yLinearRange;var m_width;var m_height;var m_domainXValues;var m_domainYValues;var m_showDataLabels;var m_showAxis;var m_showAttributeLines;var m_showAttributeLabels;var m_showAttributeDots;var m_labelsOffset;var m_pcaValues;var isYAxisReverted=false;const OFFSET_TYPE={Y:1,X:2};let m_currentRenderType=null;let m_rendererArea=null;var recalculatePlotSize=function(){var plotDivContainer=document.getElementsByClassName(m_rendererArea.pvtRendererAreaClassName())[0];if(!plotDivContainer){return;}
let sizeCalculator=new RenderedContentSizeCalculator();const size=sizeCalculator.getDesiredSizeToFitWindow('',plotDivContainer);var newWidth=size.width-m_margin.left-m_margin.right;var newHeight=size.height-m_margin.top-m_margin.bottom;var renderNeeded=(newWidth!==m_width)||(newHeight!==m_height);m_width=newWidth;m_height=newHeight;return renderNeeded;};function getFontSize(){return(m_database.getValue(m_settingsKeys.fontSizeForChart())+6)+'px';}
var loadPcaSettings=function(){var pcaSettings=m_database.getValue(m_settingsKeys.pcaSettings());if(!pcaSettings){console.error('pca settings not provided');return;}
m_showAxis=pcaSettings[m_keys.showAxisKey];m_showDataLabels=pcaSettings[m_keys.showDataLabelsKey];const labelsOffset=pcaSettings[m_keys.labelsOffsetKey];if(labelsOffset){m_labelsOffset=labelsOffset;}
m_showAttributeLines=m_pcaRepository.showAttributeLines();m_showAttributeLabels=m_pcaRepository.showAttributeLabel();m_showAttributeDots=m_pcaRepository.showAttributeDots();pcaValueConverter.setForceSwapDuringRender(pcaSettings[m_keys.autoSwapDataKey]);};var loadAxisRangeValues=function(){var autoDetectRange=m_pcaRepository.autoDetectRange();if(autoDetectRange){m_domainXValues=pcaValueConverter.autoDetectedXRange();m_domainYValues=pcaValueConverter.autoDetectedYRange();}else{m_domainXValues=m_pcaRepository.xRange();m_domainYValues=m_pcaRepository.yRange();}};var createVisualizationData=function(pc){const angle=Math.PI*0;function rotate(x,y,dtheta){var r=Math.sqrt(x*x+y*y);var theta=Math.atan(y/x);if(x<0)theta+=Math.PI;return{x:r*Math.cos(theta+dtheta),y:r*Math.sin(theta+dtheta)}}
var rotateObjects=function(pCContainer){pCContainer.map(function(d){var xy=rotate(d.pc1,d.pc2,angle);d.pc1=isNaN(xy.x)?0:xy.x;d.pc2=isNaN(xy.y)?0:xy.y;});};pcaValueConverter.initSelectedComponentsIndex();m_pcaObservationDotsManager.initData(pcaValueConverter.observationNamesWithPCA(pc,m_pcaObservationDotsManager.observationTypeNameKey()));m_attributeNamesWithPCA=pcaValueConverter.attributeNamesWithPCA(pc,m_attributeText);rotateObjects(m_pcaObservationDotsManager.data());rotateObjects(m_attributeNamesWithPCA);};function placeTextWithEllipsis(textString,width){var fontSize=parseInt(getFontSize());var calculatedWidth=m_textWidthCalculator.tickMarkTextWidth(textString.substring(0,textString.length),fontSize);if(calculatedWidth>=width){for(var x=textString.length-3;x>0;x-=3){var substring=textString.substring(0,x);calculatedWidth=m_textWidthCalculator.tickMarkTextWidth(substring,fontSize);if(calculatedWidth<=width){return substring+"...";}}
return"...";}
return textString;}
function getEnableCorrelation(index){if(!m_pcaRepository.enableCorrelationPercentage()){return'';}
let value=pcaCalculator.correlationPercentage(index);return` (${m_decimalPlacesFormatter.formatValue({
            precision: 2,
            value: value,
            removeTrailingZeros: true
        })} %)`;}
var renderAxis=function(){if(!m_showAxis){return;}
initLinearRanges();var xAxis=d3.axisBottom(m_xLinearRange);var yAxis=d3.axisLeft(m_yLinearRange);m_svg.append("g").attr("class","x axis").attr("transform","translate(0,"+m_height+")").call(xAxis).attr("fill","black").attr("font-size",getFontSize()).attr("font-family",null).append("text").attr("class","label").attr("x",m_width).attr("y",-6).style("text-anchor","end").attr("font-size",getFontSize()).text("PC1"+getEnableCorrelation(pcaValueConverter.firstComponentIndex()));m_svg.append("g").attr("class","y axis").call(yAxis).attr("fill","black").attr("font-size",getFontSize()).attr("font-family",null).append("text").attr("class","label").attr("transform","rotate(-90)").attr("y",6).attr("dy",".71em").style("text-anchor","end").attr("font-size",getFontSize()).text("PC2"+getEnableCorrelation(pcaValueConverter.secondComponentIndex()));};var renderLegends=function(color){var legend=m_svg.selectAll(".legend").data(color.domain()).enter().append("g").attr("class","legend").attr("transform",function(d,i){return"translate(0,"+i*20+")";});legend.append("rect").attr("x",m_width-18).attr("width",18).attr("height",18).style("fill",color);legend.append("text").attr("x",m_width-24).attr("y",9).attr("font-size",getFontSize()).attr("dy",".35em").style("text-anchor","end").text(function(d){return d;});};var renderAttributeDotAndText=function(color){var viewportManager=new PcaViewportManager(m_width,m_height);if(m_showAttributeLabels){m_svg.selectAll("text."+m_attributeText).data(m_attributeNamesWithPCA).enter().append("text").attr("class","label-"+m_attributeText).attr("y",function(d){let attributeName=pcaValueConverter.displayInnerValue(d[m_attributeText]);return applyOffset(m_yLinearRange(d.pc2)+0,OFFSET_TYPE.Y,attributeName);}).text(function(d){return pcaValueConverter.displayInnerValue(d[m_attributeText])}).attr("x",function(d){let attributeName=pcaValueConverter.displayInnerValue(d[m_attributeText]);var xValue=applyOffset(m_xLinearRange(d.pc1)+10,OFFSET_TYPE.X,attributeName);this.textContent=placeTextWithEllipsis(this.textContent,(m_width-xValue));return xValue;}).attr("font-size",getFontSize());viewportManager.removeTextElementsOutsideViewport(m_svg.selectAll(".label-"+m_attributeText))}
m_svg.selectAll("circle."+m_attributeText).data(m_attributeNamesWithPCA).enter().append("circle").attr("class","square").attr("r",7).attr("cx",function(d){return m_xLinearRange(d.pc1);}).attr("cy",function(d){return m_yLinearRange(d.pc2);}).attr("font-size",getFontSize()).style("fill",function(d){return color(d[m_attributeText]);}).append("title").text(function(obj){return pcaValueConverter.displayInnerValue(obj[m_attributeText]);});viewportManager.removeDotElementsOutsideViewport(m_svg.selectAll(".square"));};var getObject=function(key){if(!m_labelsOffset){return undefined;}
for(var i=0;i<m_labelsOffset.length;++i){var object=m_labelsOffset[i][key];if(object){return object;}}
return undefined;};var applyOffset=function(value,type,attributeName){if(!m_labelsOffset){return value;}
var attributeOffset=getObject(attributeName);if(!attributeOffset){return value;}
switch(type)
{case OFFSET_TYPE.X:value+=attributeOffset[0];break;case OFFSET_TYPE.Y:value+=isYAxisReverted?-attributeOffset[1]:attributeOffset[1];break;}
return value;};var createAndReturnPlotContainer=function(svgDom){var plotContainer=document.getElementById(renderTypes.plotContainerId);let nextElement=null;if(plotContainer){var plotContainerParent=plotContainer.parentNode;if(plotContainerParent){nextElement=plotContainer.nextSibling;plotContainerParent.removeChild(plotContainer);}}
plotContainer=document.createElement('div');plotContainer.id=renderTypes.plotContainerId;plotContainer.appendChild(svgDom);if(plotContainerParent){if(nextElement){plotContainerParent.insertBefore(plotContainer,nextElement?nextElement:plotContainerParent.childNodes[0]);}else{plotContainerParent.appendChild(plotContainer);}}
return plotContainer;};var renderAttributeLines=function(){if(!m_showAttributeLines){return;}
var viewportManager=new PcaViewportManager(m_width,m_height);pcaDuplicateElementsDetector.clear();for(let i=0;i<m_attributeNamesWithPCA.length;++i){var d=m_attributeNamesWithPCA[i];var fun=viewportManager.createLinearFunction(-d.pc1,d.pc1,-d.pc2,d.pc2);const minX=m_domainXValues[0];const maxX=m_domainXValues[1];var x1=m_xLinearRange(minX);var x2=m_xLinearRange(maxX);var y1=m_yLinearRange(fun(minX));var y2=m_yLinearRange(fun(maxX));if(pcaDuplicateElementsDetector.attributeLineAlreadyRendered(x1,x2,y1,y2)){continue;}
var line=document.createElementNS(m_svgNamespace,'line');line.classList.add(m_attributeLineClassName);line.setAttribute('x1',x1);line.setAttribute('y1',y1);line.setAttribute("x2",x2);line.setAttribute("y2",y2);line.style.pointerEvents='none';line.style.stroke=m_color(d[m_attributeText]);m_svg._groups[0][0].appendChild(line);}};var initLinearRanges=function(){var comparator=new PMI_REPORT_MODULE.ArrayComparator();loadAxisRangeValues();var yRange=[m_height,0];isYAxisReverted=comparator.compareArrays(yRange,[m_height,0]);m_xLinearRange=d3.scaleLinear().range([0,m_width]);m_yLinearRange=d3.scaleLinear().range(yRange);m_xLinearRange.domain(m_domainXValues).nice();m_yLinearRange.domain(m_domainYValues).nice();};var initPCAData=function(pivotData){try{var inputData=pcaValueConverter.inputData(pivotData);var values=pcaCalculator.createPCAMatrix(inputData);if(pcaCalculator.dataChanged()){m_pcaValues=values;}}catch(e){console.log('Issue during PCA data creation: '+e.message);}};var renderPlot=function(pivotData){if(!m_currentRenderType||!m_currentRenderType.isPCAChartType()||!pivotData){return;}
recalculatePlotSize();var svgDom=document.createElementNS(m_svgNamespace,"svg");svgDom.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink");loadPcaSettings();m_color=d3.scaleOrdinal(d3.schemeCategory10);m_svg=d3.select(svgDom);m_svg=m_svg.attr("width",m_width+m_margin.left+m_margin.right).attr("height",m_height+m_margin.top+m_margin.bottom).append("g").attr("transform","translate("+m_margin.left+","+m_margin.top+")");initPCAData(pivotData);if(m_pcaValues===undefined){renderAxis();return createAndReturnPlotContainer(svgDom);}
createVisualizationData(m_pcaValues);renderAxis();renderLegends(m_color);if(m_showAttributeDots){renderAttributeDotAndText(m_color);}
renderAttributeLines();m_pcaObservationDotsManager.setLinearRange(m_xLinearRange,m_yLinearRange);m_pcaObservationDotsManager.setViewportSize(m_width,m_height);m_pcaObservationDotsManager.renderObservationDotAndText(OFFSET_TYPE,placeTextWithEllipsis,applyOffset,m_svg,m_showDataLabels);return createAndReturnPlotContainer(svgDom);};return{initEngine:function(engine){if(!m_pcaObservationDotsManager){m_pcaObservationDotsManager=new PCAObservationDotsManager();}
engine[renderTypes.pcaRenderName]=function(pivotData){return renderPlot(pivotData);};},onWindowResize:function(pivotData){if(!recalculatePlotSize()){return;}
renderPlot(pivotData);},pcaValues:function(){crossCuttingLayer?.embeddedJavaScriptLogic?.emitSigCalledFromWebEngine(m_pcaValues,"pcaValues");return m_pcaValues;},pcaObservationDotsManager:function(){return m_pcaObservationDotsManager;},initDependencies:function(opts){if(!m_pcaObservationDotsManager){m_pcaObservationDotsManager=new PCAObservationDotsManager();}
m_pivotTableTabColorsRepository=opts.pivotTableTabColorsRepository;m_currentRenderType=opts.currentRenderType;m_rendererArea=opts.rendererArea;m_database=opts.database;m_settingsKeys=opts.settingsKeys;m_pcaObservationDotsManager.initDependencies({getFontSize:getFontSize,pivotTableTabColorsRepository:m_pivotTableTabColorsRepository});if(!m_pcaRepository){m_pcaRepository=new PMI_REPORT_MODULE.PcaSettingsRepository();m_pcaRepository.initDependencies({model:m_database});}}}})();
//# sourceURL=pcaRenderingEngine.js