PMI_REPORT_MODULE.scriptLoader.include("core/ObjectDeepCopyCreator.js");PMI_REPORT_MODULE.scriptLoader.include("core/IsNumericValueChecker.js");PMI_REPORT_MODULE.scriptLoader.include("pivotTab/models/VolcanoDataItem.js");PMI_REPORT_MODULE.scriptLoader.include("core/AverageCalculator.js");PMI_REPORT_MODULE.scriptLoader.include("core/TTestCalculator.js");PMI_REPORT_MODULE.scriptLoader.include("core/TTestInputValidator.js");PMI_REPORT_MODULE.scriptLoader.include("core/ArrayJoiner.js");PMI_REPORT_MODULE.scriptLoader.include('pivotTab/models/VolcanoPlotDataRepository.js');PMI_REPORT_MODULE.scriptLoader.include('pivotTab/models/VolcanoPlotSettingsRepository.js');PMI_REPORT_MODULE.VolcanoPlotDataRepository=function(){'use strict';let m_numericValueChecker=new PMI_REPORT_MODULE.IsNumericValueChecker();let m_avgCalculator=new AverageCalculator();let m_tTestCalculator=new PMI_REPORT_MODULE.TTestCalculator();let m_testInputValidator=new PMI_REPORT_MODULE.TTestInputValidator();let m_arrayJoiner=new PMI_REPORT_MODULE.ArrayJoiner();let m_volcanoSettings=new PMI_REPORT_MODULE.VolcanoPlotSettingsRepository();let m_pivotDataProxy=null;const NUMBER_OF_DISTRIBUTION_TAILS=2;function arrayToString(array){return m_arrayJoiner.joinArrayElements(array);}
function getValue(rawValue){if(!m_numericValueChecker.isNumeric(rawValue)){return undefined;}
return rawValue;}
function calculateFoldChange(opts){let reference=m_avgCalculator.calculate(opts.references);let sample=m_avgCalculator.calculate(opts.samples);if(reference.length===0||sample.length===0||!reference){return undefined;}
return getValue(sample/reference);}
function isTTestCorrectDatasets(opts){return m_testInputValidator.isTTestCorrectDatasets(opts);}
return Object.freeze({data:function(pivotData){let rowKeys=pivotData.getRowKeys();let colKeys=pivotData.getColKeys();let rows=[];pivotData.initColKeysIndexToFlatColKey();pivotData.initRowKeysIndexToFlatRowKey();let flatRows=pivotData.rowKeysIndexToFlatRowKey();let flatCols=pivotData.colKeysIndexToFlatColKey();m_volcanoSettings.initDefaultValues(flatCols);let referenceFlatColumns=m_volcanoSettings.referenceColumns();let controlFlatColumns=m_volcanoSettings.testColumns();const rowAttrs=pivotData.rowAttrs;for(let i=0,size=rowKeys.length;i<size;++i){let item=new PMI_REPORT_MODULE.VolcanoDataItem();let rowKey=flatRows[i];item.setDataName(arrayToString(m_pivotDataProxy.parseFactorEntryValue(rowKeys[i],rowAttrs)));let referenceValues=[];let sampleValues=[];for(let j=0,size=colKeys.length;j<size;++j){let colKey=flatCols[j];let agg=pivotData.getAggregator(rowKey,colKey);if(!agg){continue;}
let rawValue=agg.value();if(!m_numericValueChecker.isNumeric(rawValue)){continue;}
if(referenceFlatColumns.includes(colKey)){referenceValues.push(rawValue);}else if(controlFlatColumns.includes(colKey)){sampleValues.push(rawValue);}}
item.setFoldChange(calculateFoldChange({references:referenceValues,samples:sampleValues}));if(isTTestCorrectDatasets({firstDataset:referenceValues,secondDataset:sampleValues})){item.setPValue(getValue(m_tTestCalculator.computeTTestEqual(referenceValues,sampleValues,NUMBER_OF_DISTRIBUTION_TAILS)['chance_probability']));}
if(item.isValid()){rows.push(item);}}
return rows;},initDependencies:function(opts){m_volcanoSettings.initDependencies(opts);m_pivotDataProxy=opts.pivotDataProxy;}})};
//# sourceURL=VolcanoPlotDataRepository.js