PMI_REPORT_MODULE.colorFormatter=(function(){'use strict';var hexToRgb=function(hex){hex=hex.replace(/#/g,'');var color=undefined;var m=hex.match(/^\W*([0-9A-F]{3}([0-9A-F]{3})?)\W*$/i);if(m){color=[];if(m[1].length===6){color[0]=parseInt(m[1].substr(0,2),16);color[1]=parseInt(m[1].substr(2,2),16);color[2]=parseInt(m[1].substr(4,2),16);}else{color[0]=parseInt(m[1].charAt(0)+m[1].charAt(0),16);color[1]=parseInt(m[1].charAt(1)+m[1].charAt(1),16);color[2]=parseInt(m[1].charAt(2)+m[1].charAt(2),16);}}
return color;};var rgbToHex=function(rgb){return String("#"+((1<<24)+(parseInt(rgb[0])<<16)+(parseInt(rgb[1])<<8)+parseInt(rgb[2])).toString(16).slice(1)).toUpperCase();};var computeContrastColor=function(hex){var color=hexToRgb(hex);if(color===undefined){return'white';}
var yiq=((color[0]*299)+(color[1]*587)+(color[2]*114))/1000;return(yiq>=128)?'black':'white';};var interpolateRgbColor=function(color1,color2,factor){if(arguments.length<3){factor=0.5;}
let result=color1.slice();for(let i=0;i<3;i++){result[i]=Math.round(result[i]+factor*(color2[i]-color1[i]));}
return result;};let hexColorToRgbInt=function(hexString){if(hexString.startsWith('#')){hexString=hexString.slice(1);}
let value=parseInt(hexString,16);if(isNaN(value)){return 0;}
return value;};function invertHex(hex){if(hex.indexOf('#')===0){hex=hex.slice(1);}
let padZero=function(str,len){len=len||2;let zeros=new Array(len).join('0');return(zeros+str).slice(-len);};let r=parseInt(hex.slice(0,2),16),g=parseInt(hex.slice(2,4),16),b=parseInt(hex.slice(4,6),16);r=(255-r).toString(16);g=(255-g).toString(16);b=(255-b).toString(16);return String("#"+padZero(r)+padZero(g)+padZero(b)).toUpperCase();}
function hslToRgb(hsl){var h=hsl[0]/360,s=hsl[1]/100,l=hsl[2]/100,t1,t2,t3,rgb,val;if(s==0){val=l*255;return[val,val,val];}
if(l<0.5)
t2=l*(1+s);else
t2=l+s-l*s;t1=2*l-t2;rgb=[0,0,0];for(var i=0;i<3;i++){t3=h+1/3* -(i-1);t3<0&&t3++;t3>1&&t3--;if(6*t3<1)
val=t1+(t2-t1)*6*t3;else if(2*t3<1)
val=t2;else if(3*t3<2)
val=t1+(t2-t1)*(2/3-t3)*6;else
val=t1;rgb[i]=val*255;}
return rgb;}
return{computeContrastColor:computeContrastColor,invertHex:invertHex,interpolateRgbColor:interpolateRgbColor,hexToRgb:hexToRgb,rgbToHex:rgbToHex,hslToRgb:hslToRgb,rgbStringToRgb:function(rgbString){let values=rgbString.match(/\d+/g).slice(0,3);let numbers=[];for(let i=0,size=values.length;i<size;++i){numbers[i]=parseInt(values[i]);}
return numbers;},hexColorToRgbInt:hexColorToRgbInt}})();
//# sourceURL=colorFormatter.js